/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc;

import com.neep.neepmeat.api.plc.instruction.CallInstruction;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.BinaryInstruction;
import com.neep.neepmeat.plc.instruction.ComparisonInstruction;
import com.neep.neepmeat.plc.instruction.DupInstruction;
import com.neep.neepmeat.plc.instruction.FreeInstruction;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.OverInstruction;
import com.neep.neepmeat.plc.instruction.PCInstruction;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.instruction.PopInstruction;
import com.neep.neepmeat.plc.instruction.RotInstruction;
import com.neep.neepmeat.plc.instruction.SwpInstruction;
import com.neep.neepmeat.plc.instruction.UnaryInstruction;
import com.neep.neepmeat.plc.instruction.memory.AllotInstruction;
import com.neep.neepmeat.plc.instruction.memory.FetchInstruction;
import com.neep.neepmeat.plc.instruction.memory.FillInstruction;
import com.neep.neepmeat.plc.instruction.memory.StoreInstruction;
import com.neep.neepmeat.plc.instruction.stack.FromRetInstruction;
import com.neep.neepmeat.plc.instruction.stack.PickInstruction;
import com.neep.neepmeat.plc.instruction.stack.RetAddInstruction;
import com.neep.neepmeat.plc.instruction.stack.RetEqInstruction;
import com.neep.neepmeat.plc.instruction.stack.RetFetchInstruction;
import com.neep.neepmeat.plc.instruction.stack.ToRetInstruction;

public class SingletonInstructions {
    public static final Instruction PC = new PCInstruction();
    public static final Instruction POP = new PopInstruction();
    public static final Instruction SWAP = new SwpInstruction();
    public static final Instruction DUP = new DupInstruction();
    public static final Instruction OVER = new OverInstruction();
    public static final Instruction ROT = new RotInstruction();
    public static final Instruction PICK = new PickInstruction();
    public static final Instruction TO_RET = new ToRetInstruction();
    public static final Instruction FROM_RET = new FromRetInstruction();
    public static final Instruction RET_FETCH = new RetFetchInstruction();
    public static final Instruction RET_ADD = new RetAddInstruction();
    public static final Instruction RET_EQ = new RetEqInstruction();
    public static final PlcInstruction CALL = new CallInstruction(null);
    public static final PlcInstruction FREE = new FreeInstruction();
    public static final PlcInstruction STORE = new StoreInstruction();
    public static final PlcInstruction ALLOT = new AllotInstruction();
    public static final PlcInstruction FETCH = new FetchInstruction();
    public static final PlcInstruction FILL = new FillInstruction();
    public static final Instruction EQ = new ComparisonInstruction.Equals();
    public static final Instruction LT = new ComparisonInstruction.LessThan();
    public static final Instruction LTEQ = new ComparisonInstruction.LessThanEqual();
    public static final Instruction GT = new ComparisonInstruction.GreaterThan();
    public static final Instruction GTEQ = new ComparisonInstruction.GreaterThanEqual();
    public static final Instruction INC = new UnaryInstruction(() -> Instructions.INC, l -> l + 1);
    public static final Instruction DEC = new UnaryInstruction(() -> Instructions.DEC, l -> l - 1);
    public static final Instruction NEG = new UnaryInstruction(() -> Instructions.NEG, l -> -l);
    public static final Instruction ADD = new BinaryInstruction(() -> Instructions.ADD, Integer::sum);
    public static final Instruction SUB = new BinaryInstruction(() -> Instructions.SUB, (f, l) -> f - l);
    public static final Instruction MUL = new BinaryInstruction(() -> Instructions.MUL, (f, l) -> f * l);
    public static final Instruction DIV = new BinaryInstruction(() -> Instructions.DIV, (f, l) -> l != 0 ? f / l : Integer.signum(l) * Integer.signum(f) * Integer.MAX_VALUE);
    public static final Instruction NOT = new UnaryInstruction(() -> Instructions.NOT, l -> ~l);
    public static final Instruction AND = new BinaryInstruction(() -> Instructions.AND, (f, l) -> f & l);
    public static final Instruction OR = new BinaryInstruction(() -> Instructions.OR, (f, l) -> f | l);
    public static final Instruction NAND = new BinaryInstruction(() -> Instructions.NAND, (f, l) -> ~(f & l));
    public static final Instruction NOR = new BinaryInstruction(() -> Instructions.NOR, (f, l) -> ~(f | l));
    public static final Instruction XOR = new BinaryInstruction(() -> Instructions.XOR, (f, l) -> f ^ l);
    public static final Instruction XNOR = new BinaryInstruction(() -> Instructions.XNOR, (f, l) -> ~(f ^ l));
}

