/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.arm;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.robot.PLCActuator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class RoboticArmBlockEntity
extends SyncableBlockEntity
implements PLCActuator,
PLCActuator.Provider,
MotorisedBlock,
MotorisedBlock.DiagnosticsProvider {
    private float power;
    @Nullable
    private class_2338 target;
    private final float minPower = 0.05f;
    private double tipX = this.method_11016().method_10263() + 1;
    private double tipY = this.method_11016().method_10264() + 1;
    private double tipZ = this.method_11016().method_10260();
    public double prevX = this.tipX;
    public double prevY = this.tipY;
    public double prevZ = this.tipZ;
    private final double range = 4.5;
    private class_243 targetVec = new class_243(this.tipX, this.tipY, this.tipZ);
    @Nullable
    private ResourceAmount<ItemVariant> stored;

    public RoboticArmBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10549("rx", this.tipX);
        nbt.method_10549("ry", this.tipY);
        nbt.method_10549("rz", this.tipZ);
        nbt.method_10549("tx", this.targetVec.field_1352);
        nbt.method_10549("ty", this.targetVec.field_1351);
        nbt.method_10549("tz", this.targetVec.field_1350);
        nbt.method_10548("power", this.power);
        nbt.method_10566("stored", (class_2520)PlcInstruction.writeItem(this.stored));
        if (this.target != null) {
            nbt.method_10566("target", (class_2520)class_2512.method_10692((class_2338)this.target));
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.tipX = nbt.method_10574("rx");
        this.tipY = nbt.method_10574("ry");
        this.tipZ = nbt.method_10574("rz");
        this.power = nbt.method_10583("power");
        this.targetVec = new class_243(nbt.method_10574("tx"), nbt.method_10574("ty"), nbt.method_10574("tz"));
        this.stored = PlcInstruction.readItem(nbt.method_10562("stored"));
        if (nbt.method_10545("target")) {
            this.target = class_2512.method_10691((class_2487)nbt.method_10562("target"));
        }
    }

    public void serverTick() {
        this.prevX = this.tipX;
        this.prevY = this.tipY;
        this.prevZ = this.tipZ;
        this.moveTo(this.targetVec);
    }

    public void clientTick() {
        this.moveTo(this.targetVec);
    }

    private void moveTo(class_243 toPos) {
        if (!this.reachedTarget(null)) {
            double dx = toPos.field_1352 - this.tipX;
            double dy = toPos.field_1351 - this.tipY;
            double dz = toPos.field_1350 - this.tipZ;
            double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double vx = dx;
            double vy = dy;
            double vz = dz;
            if (dist > this.getSpeed()) {
                vx = vx / dist * this.getSpeed();
                vy = vy / dist * this.getSpeed();
                vz = vz / dist * this.getSpeed();
            }
            if (this.origin().method_1028(this.tipX + vx, this.tipY + vy, this.tipZ + vz) >= 20.25) {
                return;
            }
            this.tipX += vx;
            this.tipY += vy;
            this.tipZ += vz;
        }
    }

    private class_243 origin() {
        return new class_243((double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5);
    }

    private double getSpeed() {
        if (this.power < 0.05f) {
            return 0.0;
        }
        return class_3532.method_15350((double)this.power, (double)0.0, (double)1.5);
    }

    @Override
    public void setTarget(PLC plc, @Nullable class_2338 target) {
        if (this.power < 0.05f) {
            plc.raiseError(new PLC.Error("Insufficient power"));
        }
        this.target = target;
        this.targetVec = target != null ? class_243.method_26410((class_2382)target, (double)0.0) : new class_243(this.tipX, this.tipY, this.tipZ);
        this.sync();
    }

    @Override
    public boolean reachedTarget(@Nullable PLC plc) {
        return this.target == null || this.targetVec.method_1028(this.tipX, this.tipY, this.tipZ) <= 0.010000000000000002;
    }

    @Override
    public void spawnItem(@Nullable ResourceAmount<ItemVariant> stored) {
        if (stored == null) {
            return;
        }
        class_1264.method_5449((class_1937)this.method_10997(), (double)this.tipX, (double)this.tipY, (double)this.tipZ, (class_1799)((ItemVariant)stored.resource()).toStack((int)stored.amount()));
    }

    @Override
    public void dumpStored(PLC plc) {
        if (this.stored != null) {
            this.spawnItem(this.stored);
            this.stored = null;
            this.method_5431();
        }
    }

    @Override
    public void setStored(PLC plc, @Nullable ResourceAmount<ItemVariant> stored) {
        this.stored = stored;
        this.method_5431();
    }

    @Override
    public class_2338 getBasePos() {
        return this.field_11867;
    }

    @Override
    @Nullable
    public ResourceAmount<ItemVariant> getStored(PLC plc) {
        return this.stored;
    }

    @Override
    public double getX() {
        return this.tipX;
    }

    @Override
    public double getY() {
        return this.tipY;
    }

    @Override
    public double getZ() {
        return this.tipZ;
    }

    @Override
    public boolean actuatorRemoved() {
        return this.method_11015();
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        return false;
    }

    @Override
    public void setInputPower(float power) {
        this.power = power;
        this.sync();
    }

    @Override
    public PLCActuator getPlcActuator() {
        return this;
    }

    @Override
    public MotorisedBlock.Diagnostics getDiagnostics() {
        return MotorisedBlock.Diagnostics.insufficientPower(this.power <= 0.05f, this.power, 0.05f);
    }
}

