/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.robot.RobotAction;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelayInstruction
implements PlcInstruction {
    private final int time;
    private final DelayAction action = new DelayAction();

    public DelayInstruction(int time) {
        this.time = time;
        this.action.counter = time;
    }

    public DelayInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this.time = nbt.method_10550("time");
        this.action.counter = nbt.method_10550("counter");
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10569("time", this.time);
        nbt.method_10569("counter", this.action.counter);
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        plc.addRobotAction(this.action, this::finish);
    }

    private void finish(PLC plc) {
        this.action.counter = this.time;
        plc.advanceCounter();
    }

    @Override
    public void cancel(PLC plc) {
        this.action.counter = this.time;
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.DELAY;
    }

    public static PlcParsedInstruction parse(NeepAsmTokenView view, NeepAsmParser parser, @Nullable String scope) throws NeepASM.ParseException {
        view.fastForward();
        if (!NeepAsmTokenView.isDigit(view.peek())) {
            throw new NeepASM.ParseException("expected delay in ticks");
        }
        int delay = view.nextInteger();
        return (world, source, program) -> program.addBack(new DelayInstruction(delay));
    }

    private class DelayAction
    implements RobotAction {
        private int counter;

        private DelayAction() {
        }

        @Override
        public boolean finished(PLC plc) {
            return this.counter == 0;
        }

        @Override
        public void start(PLC plc) {
        }

        @Override
        public void tick(PLC plc) {
            this.counter = Math.max(0, this.counter - 1);
        }

        @Override
        public void end(PLC plc) {
            this.counter = DelayInstruction.this.time;
        }
    }
}

