/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.RedstoneInterface;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;

public class EmitRedstoneInstruction
implements PlcInstruction {
    private final Argument target;
    private final int strength;
    private final boolean useStack;
    private final LazyBlockApiCache<RedstoneInterface, class_2350> redstoneCache;

    public EmitRedstoneInstruction(Supplier<class_1937> world, Argument argument, int strength, boolean useStack) {
        this.target = argument;
        this.strength = strength;
        this.useStack = useStack;
        this.redstoneCache = LazyBlockApiCache.of(RedstoneInterface.LOOKUP, world, this.target);
    }

    public EmitRedstoneInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this.target = Argument.fromNbt(nbt.method_10562("target"));
        this.strength = nbt.method_10550("strength");
        this.useStack = nbt.method_10577("use_stack");
        this.redstoneCache = LazyBlockApiCache.of(RedstoneInterface.LOOKUP, world, this.target);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("target", (class_2520)this.target.toNbt());
        nbt.method_10569("strength", this.strength);
        nbt.method_10556("use_stack", this.useStack);
        return nbt;
    }

    @Override
    public boolean canStart(PLC plc) {
        if (plc instanceof class_2586) {
            class_2586 be = (class_2586)plc;
            return be.method_10997().method_8510() % 2L == 0L;
        }
        return false;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        RedstoneInterface redstone = this.redstoneCache.find();
        if (redstone != null) {
            redstone.setEmittedStrength(this.useStack ? plc.dataStack().popInt() : this.strength);
        }
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.EMIT_REDSTONE;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser) throws NeepASM.ParseException {
        view.fastForward();
        Argument target = parser.parseWorldTarget(view);
        if (target == null) {
            throw new NeepASM.ParseException("expected redstone target");
        }
        view.fastForward();
        if (!NeepAsmTokenView.isDigit(view.peek())) {
            parser.assureLineEnd(view);
            return (world, source, program) -> program.addBack(new EmitRedstoneInstruction(() -> world, target, 0, true));
        }
        int strength = view.nextInteger();
        return (world, source, program) -> program.addBack(new EmitRedstoneInstruction(() -> world, target, strength, false));
    }
}

