/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.InstructionParser;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.neepasm.vm.VM;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SayInstruction
implements Instruction {
    private final String message;
    private final char format;

    public SayInstruction(String message) {
        this.message = message;
        this.format = (char)32;
    }

    public SayInstruction(char format) {
        this.format = format;
        this.message = "";
    }

    public SayInstruction(class_2487 nbtCompound) {
        this.message = nbtCompound.method_10558("message");
        this.format = (char)nbtCompound.method_10568("format");
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10582("message", this.message);
        nbt.method_10575("format", (short)this.format);
        return nbt;
    }

    @Override
    public void start(VM plc) throws NeepASM.RuntimeException {
        if (this.message.isEmpty()) {
            DataStack.Entry value = plc.dataStack().pop();
            if (value.pointer() && plc instanceof PLC) {
                PLC memory = (PLC)plc;
                DataVariant data = memory.getMemory().fetch(value.value()).toDataVariant();
                if (this.format == ' ' || !data.isNumeric()) {
                    plc.say(data.stringValue());
                } else {
                    plc.say(this.formatNumber(data.intValue()));
                }
            } else {
                plc.say(this.formatNumber(value.value()));
            }
        } else {
            plc.say(this.message);
        }
        plc.advanceCounter();
    }

    private String formatNumber(int value) {
        return this.format == 'b' ? Integer.toBinaryString(Math.round(value)) : (this.format == 'h' ? Integer.toHexString(Math.round(value)) : String.valueOf(value));
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.SAY;
    }

    public static class Parser
    implements InstructionParser {
        @Override
        public ParsedInstruction parse(NeepAsmTokenView view, NeepAsmParser parser, @Nullable String scope) throws NeepASM.ParseException {
            char format;
            view.fastForward();
            char c = view.peek();
            if (c == '\"') {
                String message = view.nextString();
                if (message != null) {
                    parser.assureLineEnd(view);
                    return (source, program) -> new SayInstruction(message);
                }
                throw new NeepASM.ParseException("expected message string");
            }
            if (view.isIdentifier(0, c)) {
                if (c != 'd' && c != 'h' && c != 'b') {
                    throw new NeepASM.ParseException("format must be 'd', 'h', or 'b'");
                }
                format = c;
                view.next();
            } else {
                format = 'd';
            }
            parser.assureLineEnd(view);
            return (source, program) -> new SayInstruction(format);
        }
    }
}

