/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.google.common.collect.Lists;
import com.neep.neepmeat.api.plc.instruction.InstructionBuilder;
import com.neep.neepmeat.api.plc.instruction.InstructionException;
import com.neep.neepmeat.api.plc.instruction.SimpleInstructionProvider;
import com.neep.neepmeat.neepasm.program.KeyValue;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.Instruction;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1937;

public class SimpleInstructionBuilder
implements InstructionBuilder {
    private final SimpleInstructionProvider provider;
    private final List<Argument> arguments = Lists.newArrayList();
    private final class_1937 world;
    private final Consumer<Instruction> finished;

    public SimpleInstructionBuilder(SimpleInstructionProvider provider, class_1937 world, Consumer<Instruction> finished) {
        this.provider = provider;
        this.world = world;
        this.finished = finished;
        if (this.isComplete()) {
            finished.accept(this.build());
        }
    }

    @Override
    public InstructionBuilder argument(Argument argument) {
        this.arguments.add(argument);
        if (this.isComplete()) {
            this.finished.accept(this.build());
            this.arguments.clear();
        }
        return this;
    }

    @Override
    public InstructionBuilder keyValue(KeyValue kv) throws InstructionException {
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.arguments.size() >= this.provider.maxArguments();
    }

    @Override
    public Instruction build() {
        return this.provider.create(this.world, this.arguments);
    }

    @Override
    public int argumentCount() {
        return this.arguments.size();
    }
}

