/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.memory;

import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.plc.processor.MemoryType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MemoryEntry {
    public static final MemoryEntry NULL = new IntegerEntry(0);

    @Nullable
    public static MemoryEntry read(ByteBuf bb) {
        MemoryType type = MemoryType.fromCode(bb.readByte());
        return type.create.apply(bb);
    }

    public static MemoryEntry of(DataVariant data) {
        if (data.isNumeric()) {
            return new IntegerEntry(data.intValue());
        }
        return new StringEntry(data.stringValue());
    }

    public static void write(@Nullable MemoryEntry entry, ByteBuf bb) {
        if (entry == null) {
            bb.writeByte(-1);
        } else {
            bb.writeByte((int)entry.type().code);
            entry.write(bb);
        }
    }

    public MemoryType type();

    public void write(ByteBuf var1);

    public DataVariant toDataVariant();

    public record IntegerEntry(int value) implements MemoryEntry
    {
        @Override
        public MemoryType type() {
            return MemoryType.INTEGER;
        }

        @Override
        public void write(ByteBuf bb) {
            bb.writeInt(this.value);
        }

        @Override
        public DataVariant toDataVariant() {
            return DataVariant.of(this.value);
        }

        @Override
        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }

        public static MemoryEntry read(ByteBuf bb) {
            return new IntegerEntry(bb.readInt());
        }
    }

    public record StringEntry(String value) implements MemoryEntry
    {
        @Override
        public MemoryType type() {
            return MemoryType.STRING;
        }

        @Override
        public void write(ByteBuf bb) {
            bb.writeInt(this.value.length());
            bb.writeCharSequence((CharSequence)this.value, StandardCharsets.ISO_8859_1);
        }

        @Override
        public DataVariant toDataVariant() {
            return DataVariant.of(this.value);
        }

        @Override
        @NotNull
        public String toString() {
            return this.value;
        }

        public static MemoryEntry read(ByteBuf bb) {
            int length = bb.readInt();
            return new StringEntry(bb.readCharSequence(length, StandardCharsets.ISO_8859_1).toString());
        }
    }
}

