/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.processor;

import com.neep.neepmeat.plc.memory.ItemRequestMemoryEntry;
import com.neep.neepmeat.plc.memory.MemoryEntry;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;

public enum MemoryType {
    STRING(2, MemoryEntry.StringEntry::read),
    INTEGER(0, MemoryEntry.IntegerEntry::read),
    ITEM_RESOURCE_AMOUNT(8, ItemRequestMemoryEntry::read),
    NULL(-1, bb -> null);

    public final byte code;
    public final Function<ByteBuf, MemoryEntry> create;

    public static MemoryType fromCode(byte code) {
        return switch (code) {
            case 0 -> INTEGER;
            case 2 -> STRING;
            case 8 -> ITEM_RESOURCE_AMOUNT;
            default -> NULL;
        };
    }

    private MemoryType(int code, Function<ByteBuf, MemoryEntry> create) {
        this.code = (byte)code;
        this.create = create;
    }

    public boolean stackDirect() {
        return this == INTEGER;
    }
}

