/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.network.PacketBufUtil;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatlibRecipe;
import com.neep.meatlib.recipe.ingredient.Ingredients;
import com.neep.meatlib.recipe.ingredient.RecipeInput;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.live_machine.process.BioreactorProcess;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class BioreactorRecipe
implements MeatlibRecipe<BioreactorProcess.Context> {
    private final class_2960 id;
    private final List<RegistryRecipeInput<class_1792>> itemInputs;
    private final List<RegistryRecipeInput<class_3611>> fluidInputs;
    private final RecipeOutput<class_3611> output;
    private final int processTime;

    public BioreactorRecipe(class_2960 id, List<RegistryRecipeInput<class_1792>> itemInputs, List<RegistryRecipeInput<class_3611>> fluidInputs, RecipeOutput<class_3611> output, int processTime) {
        this.id = id;
        this.itemInputs = itemInputs;
        this.fluidInputs = fluidInputs;
        this.output = output;
        this.processTime = processTime;
    }

    @Override
    public boolean matches(BioreactorProcess.Context context) {
        int satisfied = this.itemInputs.size();
        for (RegistryRecipeInput<class_1792> registryRecipeInput : this.itemInputs) {
            if (!registryRecipeInput.testStorage(context.itemInput())) continue;
            --satisfied;
        }
        for (RegistryRecipeInput<class_1792> registryRecipeInput : this.fluidInputs) {
            if (!registryRecipeInput.testStorage(context.fluidInput())) continue;
            --satisfied;
        }
        return satisfied <= 0;
    }

    @Override
    public boolean takeInputs(BioreactorProcess.Context context, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            for (RegistryRecipeInput<class_1792> registryRecipeInput : this.itemInputs) {
                if (registryRecipeInput.extract(context.itemInput(), ItemVariant::of, (TransactionContext)inner)) continue;
                boolean bl = false;
                return bl;
            }
            for (RegistryRecipeInput<class_1792> registryRecipeInput : this.fluidInputs) {
                if (registryRecipeInput.extract(context.fluidInput(), FluidVariant::of, (TransactionContext)inner)) continue;
                boolean bl = false;
                return bl;
            }
            inner.commit();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean ejectOutputs(BioreactorProcess.Context context, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            if (this.output.insertInto(context.fluidOutput(), FluidVariant::of, (TransactionContext)inner)) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.BIOREACTOR_SERIALISER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.BIOREACTOR;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public List<RegistryRecipeInput<class_1792>> getItemInputs() {
        return this.itemInputs;
    }

    public List<RegistryRecipeInput<class_3611>> getFluidInputs() {
        return this.fluidInputs;
    }

    public RecipeOutput<class_3611> getOutputs() {
        return this.output;
    }

    public static class Serialiser
    implements MeatRecipeSerialiser<BioreactorRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<BioreactorRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(RecipeInputs.ANY).flatComapMap(Serialiser::sortInputs, r -> DataResult.error(() -> "Not implemented")).fieldOf("inputs").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.FLUID.fieldOf("output").forGetter(MeatLibCodecs::notImplemented), (App)Codec.INT.fieldOf("process_time").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (i, o, t) -> id -> new BioreactorRecipe(id, (List)i.getFirst(), (List)i.getSecond(), (RecipeOutput<class_3611>)o, (int)t)));

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<BioreactorRecipe>> codec() {
            return this.codec;
        }

        private static Pair<List<RegistryRecipeInput<class_1792>>, List<RegistryRecipeInput<class_3611>>> sortInputs(List<RecipeInput<?, ?>> inputs) {
            ArrayList<RegistryRecipeInput> itemInputs = new ArrayList<RegistryRecipeInput>();
            ArrayList<RegistryRecipeInput> fluidInputs = new ArrayList<RegistryRecipeInput>();
            for (RecipeInput<?, ?> recipeInput : inputs) {
                if (!(recipeInput instanceof RegistryRecipeInput)) continue;
                RegistryRecipeInput rri = (RegistryRecipeInput)recipeInput;
                if (recipeInput.getType() == Ingredients.ITEM) {
                    itemInputs.add(rri);
                    continue;
                }
                if (recipeInput.getType() != Ingredients.FLUID) continue;
                fluidInputs.add(rri);
            }
            return new Pair(itemInputs, fluidInputs);
        }

        @Override
        public BioreactorRecipe read(class_2960 id, class_2540 buf) {
            List<RegistryRecipeInput<class_1792>> itemInputs = PacketBufUtil.readList(buf, RegistryRecipeInput::fromBuffer);
            List<RegistryRecipeInput<class_3611>> fluidInputs = PacketBufUtil.readList(buf, RegistryRecipeInput::fromBuffer);
            RecipeOutputImpl<class_3611> output = RecipeOutputImpl.read(class_7923.field_41173, buf);
            int processTime = buf.method_10816();
            return new BioreactorRecipe(id, itemInputs, fluidInputs, output, processTime);
        }

        @Override
        public void write(class_2540 buf, BioreactorRecipe recipe) {
            PacketBufUtil.writeList(buf, recipe.fluidInputs, (b, i) -> i.write((class_2540)b));
            PacketBufUtil.writeList(buf, recipe.itemInputs, (b, i) -> i.write((class_2540)b));
            recipe.output.write(buf);
            buf.method_10804(recipe.processTime);
        }
    }
}

