/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.thord;

import com.neep.neepmeat.plc.SingletonInstructions;
import com.neep.neepmeat.plc.instruction.BIFInstruction;
import com.neep.neepmeat.plc.instruction.BITInstruction;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.JumpInstruction;
import com.neep.neepmeat.plc.instruction.PushInstruction;
import com.neep.neepmeat.thord.word.Word;

public class ThordWords {
    public static final Word CPHEAD = (acceptor, stack, line) -> stack.push(acceptor.size());
    public static final Word PLUS_STORE = (acceptor, stack, line) -> {
        acceptor.instruction(SingletonInstructions.DUP, line);
        acceptor.instruction(SingletonInstructions.FETCH, line);
        acceptor.instruction(SingletonInstructions.ROT, line);
        acceptor.instruction(SingletonInstructions.ADD, line);
        acceptor.instruction(SingletonInstructions.SWAP, line);
        acceptor.instruction(SingletonInstructions.STORE, line);
    };
    public static final Word IF = (acceptor, stack, line) -> {
        stack.push(acceptor.size());
        acceptor.instruction(Instruction.EMPTY, line);
    };
    public static final Word ELSE = (acceptor, stack, line) -> {
        int bifPosition = stack.popInt();
        int head = acceptor.size();
        acceptor.instruction(bifPosition, (labelLookup, program) -> new BIFInstruction(head - bifPosition + 1), line);
        stack.push(acceptor.size());
        acceptor.instruction(Instruction.EMPTY, line);
        stack.push(-1);
    };
    public static final Word ENDIF = (acceptor, stack, line) -> {
        boolean isElse;
        boolean bl = isElse = stack.dataStack().peekInt(0) == -1;
        if (!isElse) {
            int head = acceptor.size();
            int bifPosition = stack.popInt();
            acceptor.instruction(bifPosition, (labelLookup, program) -> new BIFInstruction(head - bifPosition), line);
        } else {
            stack.popInt();
            int head = acceptor.size();
            int jmpPosition = stack.popInt();
            acceptor.instruction(jmpPosition, (labelLookup, program) -> new JumpInstruction(head - jmpPosition), line);
        }
    };
    public static final Word DO = (acceptor, stack, line) -> {
        acceptor.instruction(SingletonInstructions.OVER, line);
        acceptor.instruction(SingletonInstructions.OVER, line);
        acceptor.instruction(SingletonInstructions.EQ, line);
        stack.push(acceptor.size());
        acceptor.instruction((labelLookup, program) -> Instruction.EMPTY, line);
        acceptor.instruction(SingletonInstructions.SWAP, line);
        acceptor.instruction(SingletonInstructions.TO_RET, line);
        acceptor.instruction(SingletonInstructions.TO_RET, line);
        stack.push(acceptor.size());
    };
    public static final Word LOOP = (acceptor, stack, line) -> {
        int bifPosition = stack.popInt();
        int bitPosition = stack.popInt();
        acceptor.instruction(new PushInstruction(1), line);
        acceptor.instruction(SingletonInstructions.RET_ADD, line);
        acceptor.instruction(SingletonInstructions.RET_EQ, line);
        int bifJump = bifPosition - acceptor.size();
        acceptor.instruction(new BIFInstruction(bifJump), line);
        acceptor.instruction(SingletonInstructions.FROM_RET, line);
        acceptor.instruction(SingletonInstructions.FROM_RET, line);
        int jump = acceptor.size() - bitPosition;
        acceptor.instruction(bitPosition, (labelLookup, program) -> new BITInstruction(jump), line);
        acceptor.instruction(SingletonInstructions.POP, line);
        acceptor.instruction(SingletonInstructions.POP, line);
    };
    public static final Word PLUS_LOOP = (acceptor, stack, line) -> {
        int bifPosition = stack.popInt();
        int bitPosition = stack.popInt();
        acceptor.instruction(SingletonInstructions.RET_ADD, line);
        acceptor.instruction(SingletonInstructions.RET_EQ, line);
        int bifJump = bifPosition - acceptor.size();
        acceptor.instruction(new BIFInstruction(bifJump), line);
        acceptor.instruction(SingletonInstructions.FROM_RET, line);
        acceptor.instruction(SingletonInstructions.FROM_RET, line);
        int jump = acceptor.size() - bitPosition;
        acceptor.instruction(bitPosition, (labelLookup, program) -> new BITInstruction(jump), line);
        acceptor.instruction(SingletonInstructions.POP, line);
        acceptor.instruction(SingletonInstructions.POP, line);
    };
    public static final Word BEGIN = (acceptor, stack, line) -> stack.push(acceptor.size());
    public static final Word UNTIL = (acceptor, stack, line) -> {
        int position = stack.popInt();
        acceptor.instruction(new BITInstruction(position - acceptor.size()), line);
    };
}

