/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.thord.compiler;

import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.vm.DataStack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

public class CheckedIntStack
implements DataStack {
    private final IntArrayList backing = new IntArrayList();
    private final int maxLength;
    private final String name;

    public CheckedIntStack(int maxLength, String name) {
        this.maxLength = maxLength;
        this.name = name;
    }

    public int[] toArray() {
        return this.backing.toArray(new int[0]);
    }

    public void read(int[] array) {
        this.backing.clear();
        this.backing.addAll(IntList.of((int[])array));
    }

    @Override
    public void push(int data, boolean pointer) throws NeepASM.RuntimeException {
        if (this.backing.size() >= this.maxLength) {
            throw new NeepASM.RuntimeException(this.name + " overflow");
        }
        this.backing.push(data);
    }

    @Override
    public void push(DataStack.Entry entry) throws NeepASM.RuntimeException {
        this.push(entry.value(), entry.pointer());
    }

    @Override
    public DataStack.Entry pop() throws NeepASM.RuntimeException {
        return new DataStack.Entry(this.popInt(), false);
    }

    @Override
    public int popInt() throws NeepASM.RuntimeException {
        if (this.backing.isEmpty()) {
            throw new NeepASM.RuntimeException(this.name + " underflow");
        }
        return this.backing.popInt();
    }

    public int topInt() throws NeepASM.RuntimeException {
        if (this.backing.isEmpty()) {
            throw new NeepASM.RuntimeException(this.name + " underflow");
        }
        return this.backing.topInt();
    }

    @Override
    public int peekInt(int i) throws NeepASM.RuntimeException {
        if (this.backing.isEmpty()) {
            throw new NeepASM.RuntimeException(this.name + " underflow");
        }
        return this.backing.peekInt(i);
    }

    @Override
    public DataStack.Entry peek(int i) throws NeepASM.RuntimeException {
        return new DataStack.Entry(this.peekInt(i), false);
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    public void clear() {
        this.backing.clear();
    }
}

