/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.thord.parser;

import com.neep.neepmeat.plc.SingletonInstructions;
import com.neep.neepmeat.plc.instruction.BIFInstruction;
import com.neep.neepmeat.plc.instruction.BITInstruction;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.JumpInstruction;
import com.neep.neepmeat.plc.instruction.PushInstruction;
import com.neep.neepmeat.plc.instruction.SayInstruction;
import com.neep.neepmeat.thord.ThordWords;
import com.neep.neepmeat.thord.word.Word;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ThordDictionary {
    private Map<String, Word> dictionary;

    public static Map<String, Word> initBuiltin() {
        HashMap<String, Word> map = new HashMap<String, Word>();
        map.put("blank", Word.of((labelLookup, program) -> Instruction.EMPTY));
        map.put("pc", Word.of((labelLookup, program) -> SingletonInstructions.PC));
        map.put("+", Word.of((labelLookup, program) -> SingletonInstructions.ADD));
        map.put("-", Word.of((labelLookup, program) -> SingletonInstructions.SUB));
        map.put("/", Word.of((labelLookup, program) -> SingletonInstructions.DIV));
        map.put("*", Word.of((labelLookup, program) -> SingletonInstructions.MUL));
        map.put("=", Word.of((labelLookup, program) -> SingletonInstructions.EQ));
        map.put("!=", (acceptor, stack, line) -> {
            acceptor.instruction((labelLookup, program) -> SingletonInstructions.EQ, line);
            acceptor.instruction((labelLookup, program) -> SingletonInstructions.NOT, line);
        });
        map.put(">", Word.of((labelLookup, program) -> SingletonInstructions.GT));
        map.put("<", Word.of((labelLookup, program) -> SingletonInstructions.LT));
        map.put(">=", Word.of((labelLookup, program) -> SingletonInstructions.GTEQ));
        map.put("<=", Word.of((labelLookup, program) -> SingletonInstructions.LTEQ));
        map.put("invert", Word.of((labelLookup, program) -> SingletonInstructions.NOT));
        map.put("neg", Word.of((labelLookup, program) -> SingletonInstructions.NEG));
        map.put(".", Word.of((labelLookup, program) -> new SayInstruction('d')));
        map.put("dup", Word.of((labelLookup, program) -> SingletonInstructions.DUP));
        map.put("2dup", (acceptor, stack, line) -> {
            acceptor.instruction((labelLookup, program) -> SingletonInstructions.OVER, line);
            acceptor.instruction((labelLookup, program) -> SingletonInstructions.OVER, line);
        });
        map.put("pick", Word.of((labelLookup, program) -> SingletonInstructions.PICK));
        map.put("swp", Word.of((labelLookup, program) -> SingletonInstructions.SWAP));
        map.put("2swp", (acceptor, stack, line) -> {
            acceptor.instruction((labelLookup, program) -> SingletonInstructions.ROT, line);
            acceptor.instruction((labelLookup, program) -> SingletonInstructions.TO_RET, line);
            acceptor.instruction((labelLookup, program) -> SingletonInstructions.ROT, line);
            acceptor.instruction((labelLookup, program) -> SingletonInstructions.FROM_RET, line);
        });
        map.put("over", Word.of((labelLookup, program) -> SingletonInstructions.OVER));
        map.put("2over", (acceptor, stack, line) -> {
            acceptor.instruction(new PushInstruction(3), line);
            acceptor.instruction(SingletonInstructions.PICK, line);
            acceptor.instruction(new PushInstruction(3), line);
            acceptor.instruction(SingletonInstructions.PICK, line);
        });
        map.put("rot", Word.of(SingletonInstructions.ROT));
        map.put("drop", Word.of(SingletonInstructions.POP));
        map.put("2drop", (acceptor, stack, line) -> {
            acceptor.instruction(SingletonInstructions.POP, line);
            acceptor.instruction(SingletonInstructions.POP, line);
        });
        map.put(">r", Word.of(SingletonInstructions.TO_RET));
        map.put("r>", Word.of(SingletonInstructions.FROM_RET));
        map.put("2>r", (acceptor, stack, line) -> {
            acceptor.instruction(SingletonInstructions.SWAP, line);
            acceptor.instruction(SingletonInstructions.TO_RET, line);
            acceptor.instruction(SingletonInstructions.TO_RET, line);
        });
        map.put("2r>", (acceptor, stack, line) -> {
            acceptor.instruction(SingletonInstructions.FROM_RET, line);
            acceptor.instruction(SingletonInstructions.FROM_RET, line);
            acceptor.instruction(SingletonInstructions.SWAP, line);
        });
        map.put("r@", Word.of(SingletonInstructions.RET_FETCH));
        map.put("!", Word.of(SingletonInstructions.STORE));
        map.put("+!", ThordWords.PLUS_STORE);
        map.put("@", Word.of(SingletonInstructions.FETCH));
        map.put("?", (acceptor, stack, line) -> {
            acceptor.instruction(SingletonInstructions.FETCH, line);
            acceptor.instruction(new SayInstruction(""), line);
        });
        map.put("execute", Word.of(SingletonInstructions.CALL));
        map.put("if", ThordWords.IF);
        map.put("else", ThordWords.ELSE);
        map.put("endif", ThordWords.ENDIF);
        map.put("then", ThordWords.ENDIF);
        map.put("do", ThordWords.DO);
        map.put("for", ThordWords.DO);
        map.put("i", Word.of(SingletonInstructions.RET_FETCH));
        map.put("loop", ThordWords.LOOP);
        map.put("+loop", ThordWords.PLUS_LOOP);
        map.put("begin", ThordWords.BEGIN);
        map.put("until", ThordWords.UNTIL);
        map.put("cphead", ThordWords.CPHEAD);
        map.put("cpdumpstack", (acceptor, stack, line) -> {
            StringBuilder stackString = new StringBuilder();
            for (int i = stack.dataStack().size() - 1; i >= 0; --i) {
                stackString.append(" ");
                stackString.append(stack.dataStack().peek(i).value());
            }
            stack.say(String.valueOf(stackString) + " <--");
        });
        map.put("cpjmp", ThordDictionary.compiledBranchWord((Int2ObjectFunction<Instruction>)((Int2ObjectFunction)JumpInstruction::new)));
        map.put("cpbif", ThordDictionary.compiledBranchWord((Int2ObjectFunction<Instruction>)((Int2ObjectFunction)BIFInstruction::new)));
        map.put("cpbit", ThordDictionary.compiledBranchWord((Int2ObjectFunction<Instruction>)((Int2ObjectFunction)BITInstruction::new)));
        return map;
    }

    private static Word compiledBranchWord(Int2ObjectFunction<Instruction> instruction) {
        return (acceptor, stack, line) -> {
            int jump = stack.popInt();
            int offset = stack.popInt();
            int target = acceptor.size() + offset;
            acceptor.instruction(target, (lookup, program) -> {
                int targetLine = program.getDebugLine(target);
                program.setDebugLine(targetLine != -1 ? targetLine : line);
                return (Instruction)instruction.apply(jump);
            }, line);
        };
    }

    public ThordDictionary() {
        this.reset();
    }

    public void reset() {
        this.dictionary = ThordDictionary.initBuiltin();
    }

    public void put(String name, Word word) {
        this.dictionary.put(name, word);
    }

    @Nullable
    public Word get(String name) {
        return this.dictionary.get(name);
    }

    public boolean contains(String name) {
        return this.dictionary.containsKey(name);
    }
}

