/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport;

import com.google.common.collect.Maps;
import com.neep.meatlib.item.TooltipSupplier;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.meatlib.registry.annotation.Ignore;
import com.neep.meatlib.registry.annotation.Path;
import com.neep.meatlib.registry.annotation.RegisterMe;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.item.FluidComponentItem;
import com.neep.neepmeat.item.TankItem;
import com.neep.neepmeat.machine.multitank.MultiTankBlock;
import com.neep.neepmeat.transport.api.FluidTransportConstants;
import com.neep.neepmeat.transport.api.pipe.FluidPipe;
import com.neep.neepmeat.transport.block.fluid_transport.AdvancedTankBlock;
import com.neep.neepmeat.transport.block.fluid_transport.CapillaryFluidPipeBlock;
import com.neep.neepmeat.transport.block.fluid_transport.CheckValveBlock;
import com.neep.neepmeat.transport.block.fluid_transport.EncasedFluidPipeBlock;
import com.neep.neepmeat.transport.block.fluid_transport.FilterPipeBlock;
import com.neep.neepmeat.transport.block.fluid_transport.FlexTankBlock;
import com.neep.neepmeat.transport.block.fluid_transport.FluidBufferBlock;
import com.neep.neepmeat.transport.block.fluid_transport.FluidDrainBlock;
import com.neep.neepmeat.transport.block.fluid_transport.FluidGaugeBlock;
import com.neep.neepmeat.transport.block.fluid_transport.FluidInterfaceBlock;
import com.neep.neepmeat.transport.block.fluid_transport.FluidPipeBlock;
import com.neep.neepmeat.transport.block.fluid_transport.GlassTankBlock;
import com.neep.neepmeat.transport.block.fluid_transport.LimiterValveBlock;
import com.neep.neepmeat.transport.block.fluid_transport.PumpBlock;
import com.neep.neepmeat.transport.block.fluid_transport.StopValveBlock;
import com.neep.neepmeat.transport.block.fluid_transport.TankBlock;
import com.neep.neepmeat.transport.block.fluid_transport.WindowPipeBlock;
import com.neep.neepmeat.transport.block.fluid_transport.machine.FluidPipeBlockEntity;
import com.neep.neepmeat.transport.fluid_network.FluidPipeVertex;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Nullable;

@RegisterMe(value="neepmeat")
public class FluidTransport {
    public static final RegistrationContext C = new RegistrationContext("neepmeat");
    public static final Map<FluidPipe.PipeCol, FluidPipeBlock> COLOURED_FLUID_PIPES = Maps.newEnumMap(FluidPipe.PipeCol.class);
    public static final List<FluidPipeBlock> FLUID_PIPES = new ObjectArrayList();
    public static class_2248 FLUID_PIPE = new FluidPipeBlock(C, FluidPipe.PipeCol.ANY, NMBlocks.block().factory(FluidComponentItem::new), NMBlocks.FLUID_PIPE_SETTINGS);
    public static class_2248 ENCASED_FLUID_PIPE = new EncasedFluidPipeBlock(C, FluidPipe.PipeCol.ANY, NMBlocks.block().factory(FluidComponentItem::new).tooltip(TooltipSupplier.simple(1)), NMBlocks.FLUID_PIPE_SETTINGS);
    @Ignore
    public static class_2248 WHITE_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.WHITE);
    @Ignore
    public static class_2248 ORANGE_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.ORANGE);
    @Ignore
    public static class_2248 MAGENTA_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.MAGENTA);
    @Ignore
    public static class_2248 LIGHT_BLUE_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.LIGHT_BLUE);
    @Ignore
    public static class_2248 YELLOW_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.YELLOW);
    @Ignore
    public static class_2248 LIME_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.LIME);
    @Ignore
    public static class_2248 PINK_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.PINK);
    @Ignore
    public static class_2248 GRAY_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.GRAY);
    @Ignore
    public static class_2248 LIGHT_GRAY_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.LIGHT_GRAY);
    @Ignore
    public static class_2248 CYAN_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.CYAN);
    @Ignore
    public static class_2248 PURPLE_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.PURPLE);
    @Ignore
    public static class_2248 BLUE_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.BLUE);
    @Ignore
    public static class_2248 BROWN_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.BROWN);
    @Ignore
    public static class_2248 GREEN_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.GREEN);
    @Ignore
    public static class_2248 RED_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.RED);
    @Ignore
    public static class_2248 BLACK_FLUID_PIPE = FluidTransport.makePipe(FluidPipe.PipeCol.BLACK);
    public static class_2248 FILTER_PIPE = new FilterPipeBlock(C, NMBlocks.block().tooltip(TooltipSupplier.simple(2)), NMBlocks.FLUID_PIPE_SETTINGS);
    public static class_2248 STOP_VALVE = new StopValveBlock(C, NMBlocks.block().tooltip(TooltipSupplier.simple(1)), NMBlocks.FLUID_PIPE_SETTINGS);
    public static class_2248 CHECK_VALVE = new CheckValveBlock(C, NMBlocks.block().tooltip(TooltipSupplier.simple(1)), NMBlocks.FLUID_PIPE_SETTINGS);
    public static class_2248 LIMITER_VALVE = new LimiterValveBlock(C, NMBlocks.block().tooltip(TooltipSupplier.simple(1)), NMBlocks.FLUID_PIPE_SETTINGS);
    @Path(value="window_fluid_pipe")
    public static class_2248 WINDOW_PIPE = new WindowPipeBlock(C, NMBlocks.block().tooltip(TooltipSupplier.blank()), NMBlocks.FLUID_PIPE_SETTINGS);
    public static class_2248 COPPER_PIPE = new CapillaryFluidPipeBlock(C, NMBlocks.block().tooltip(TooltipSupplier.simple(1)), NMBlocks.FLUID_PIPE_SETTINGS);
    @Path(value="pump")
    public static class_2248 PUMP = new PumpBlock(C, NMBlocks.block().tooltip(TooltipSupplier.simple(1)), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static class_2248 BASIC_TANK = new TankBlock(C, NMBlocks.block().factory(TankItem::new).tooltip(TooltipSupplier.hidden(2)), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static class_2248 BASIC_GLASS_TANK = new GlassTankBlock(C, NMBlocks.block().factory(TankItem::new).tooltip(TooltipSupplier.hidden(2)), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static class_2248 ADVANCED_TANK = new AdvancedTankBlock(C, NMBlocks.block().factory(TankItem::new).tooltip(TooltipSupplier.hidden(2)), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static class_2248 MULTI_TANK = new MultiTankBlock(C, NMBlocks.block(), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static class_2248 FLUID_BUFFER = new FluidBufferBlock(C, NMBlocks.block().tooltip(TooltipSupplier.simple(1)), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static class_2248 FLUID_INTERFACE = new FluidInterfaceBlock(C, NMBlocks.block().tooltip(TooltipSupplier.simple(1)).factory(FluidComponentItem::new), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static class_2248 FLUID_DRAIN = new FluidDrainBlock(C, NMBlocks.block().tooltip(TooltipSupplier.simple(1)), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static FlexTankBlock FLEX_TANK = new FlexTankBlock(C, 648000L, () -> NMBlockEntities.FLEX_TANK, NMBlocks.block().tooltip(TooltipSupplier.simple(2)), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static FlexTankBlock ADVANCED_FLEX_TANK = new FlexTankBlock(C, 1296000L, () -> NMBlockEntities.ADVANCED_FLEX_TANK, NMBlocks.block().tooltip(TooltipSupplier.simple(2)), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static class_2248 FLUID_GAUGE = new FluidGaugeBlock(C, () -> NMBlockEntities.FLUID_GAUGE, NMBlocks.block().tooltip(TooltipSupplier.simple(1)), NMBlocks.FLUID_MACHINE_SETTINGS);
    public static class_2248 ITEM_GAUGE = new FluidGaugeBlock(C, () -> NMBlockEntities.ITEM_GAUGE, NMBlocks.block().tooltip(TooltipSupplier.simple(1)), NMBlocks.FLUID_MACHINE_SETTINGS);

    public static void init() {
        FLUID_PIPES.add((FluidPipeBlock)FLUID_PIPE);
        FluidPipeVertex.LOOKUP.registerFallback(FluidTransport::getVertex);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)FluidTransportConstants.INSTANCE);
    }

    private static FluidPipeBlock makePipe(FluidPipe.PipeCol col) {
        FluidPipeBlock pipe = C.addParent(new class_2960("neepmeat", "fluid_pipe_" + col.name().toLowerCase(Locale.ROOT)), new FluidPipeBlock(C, col, NMBlocks.block().factory(FluidComponentItem::new), NMBlocks.FLUID_PIPE_SETTINGS));
        COLOURED_FLUID_PIPES.put(col, pipe);
        FLUID_PIPES.add(pipe);
        return pipe;
    }

    private static FluidPipeVertex getVertex(class_1937 world, class_2338 blockPos, class_2680 blockState, @Nullable class_2586 blockEntity, Void unused) {
        if (blockEntity instanceof FluidPipeBlockEntity) {
            FluidPipeBlockEntity be = (FluidPipeBlockEntity)blockEntity;
            return be.getPipeVertex();
        }
        return null;
    }
}

