/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.fluid_transport;

import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.transport.FluidPipeBlockItem;
import com.neep.neepmeat.transport.FluidTransport;
import com.neep.neepmeat.transport.api.pipe.AbstractAxialFluidPipe;
import com.neep.neepmeat.transport.api.pipe.FluidPipe;
import com.neep.neepmeat.transport.api.pipe.PrecisePipeBlock;
import com.neep.neepmeat.transport.block.fluid_transport.PumpBlock;
import com.neep.neepmeat.transport.block.fluid_transport.machine.FluidPipeBlockEntity;
import com.neep.neepmeat.transport.fluid_network.ConnectionType;
import com.neep.neepmeat.transport.fluid_network.node.BlockFluidPipeVertex;
import com.neep.neepmeat.util.MiscUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.object.Color;

public class FluidPipeBlock
extends PrecisePipeBlock
implements class_2343,
FluidPipe {
    public final FluidPipe.PipeCol col;

    public FluidPipeBlock(RegistrationContext ctx, FluidPipe.PipeCol col, ItemSettings itemSettings, class_4970.class_2251 settings) {
        super(ctx, itemSettings.factory(FluidPipeBlockItem::new), settings);
        this.col = col;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        FluidPipe.onStateReplaced(world, pos, state, newState, this);
        super.method_9536(state, world, pos, newState, moved);
        if (world.method_8608()) {
            return;
        }
        if (!state.method_27852(newState.method_26204())) {
            this.removePipe((class_3218)world, state, pos);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        class_2338 subtracted = fromPos.method_10059((class_2382)pos);
        class_2350 direction = class_2350.method_50026((int)subtracted.method_10263(), (int)subtracted.method_10264(), (int)subtracted.method_10260());
        class_2680 nextState = direction == null ? state : this.method_9559(state, direction, world.method_8320(fromPos), (class_1936)world, pos, fromPos);
        world.method_8652(pos, nextState, 2);
        class_2680 fromState = world.method_8320(fromPos);
        boolean foundPipe = FluidPipe.findFluidPipe(world, fromPos, fromState) != null;
        boolean nodeChange = false;
        if (!foundPipe) {
            nodeChange = this.createStorageNodes(world, pos, nextState);
        }
        if (foundPipe || nodeChange || !state.equals(nextState)) {
            FluidPipeBlockEntity.find(world, pos).ifPresent(be -> be.updateConnectionChange(state, nextState));
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (!world.method_8608()) {
            this.createStorageNodes(world, pos, state);
            FluidPipeBlockEntity.find(world, pos).ifPresent(be -> be.updateHiddenConnections(state));
        }
    }

    @Override
    public void onConnectionUpdate(class_1937 world, class_2680 state, class_2680 newState, class_2338 pos, class_1657 entity) {
        if (world.method_8608()) {
            return;
        }
        this.createStorageNodes(world, pos, newState);
        FluidPipeBlockEntity.find(world, pos).ifPresent(be -> be.updateConnectionChange(state, newState));
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        boolean otherIsPipe;
        boolean otherConnected;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        boolean alreadyConnected = this.getConnection(state, direction).isConnected();
        boolean canConnect = this.canConnectTo(state, neighborState, direction.method_10153(), (class_1937)world, neighborPos, alreadyConnected);
        class_2248 class_22482 = neighborState.method_26204();
        if (class_22482 instanceof FluidPipeBlock) {
            FluidPipeBlock neighborPipe = (FluidPipeBlock)class_22482;
            otherConnected = neighborPipe.getConnection(neighborState, direction.method_10153()).isConnected();
            otherIsPipe = true;
        } else {
            otherConnected = canConnect && alreadyConnected;
            otherIsPipe = false;
        }
        ConnectionType finalConnection = otherConnected || !otherIsPipe && canConnect ? ConnectionType.SIDE : ConnectionType.NONE;
        return (class_2680)state.method_11657(this.getConnection(direction), (Comparable)((Object)finalConnection));
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(class_1802.field_8600)) {
            class_2586 class_25862;
            if (!world.method_8608() && (class_25862 = world.method_8321(pos)) instanceof FluidPipeBlockEntity) {
                BlockFluidPipeVertex vertex;
                FluidPipeBlockEntity be = (FluidPipeBlockEntity)class_25862;
                Object t = be.getPipeVertex();
                if (t instanceof BlockFluidPipeVertex && !(vertex = (BlockFluidPipeVertex)t).canSimplify()) {
                    player.method_43496(class_2561.method_30163((String)("Amount: " + vertex.getAmount() + ", Pump height: " + vertex.getPumpHeight() + ", Total height: " + vertex.getTotalHeight())));
                } else {
                    player.method_43496(class_2561.method_30163((String)"No vertex"));
                }
            }
            return class_1269.field_5812;
        }
        class_1792 be = stack.method_7909();
        if (be instanceof class_1769) {
            class_1769 dyeItem = (class_1769)be;
            FluidPipe.PipeCol newCol = FluidPipe.PipeCol.get(dyeItem.method_7802());
            if (newCol != this.col) {
                FluidPipeBlock newPipe = FluidTransport.COLOURED_FLUID_PIPES.get((Object)newCol);
                world.method_8501(pos, newPipe.method_34725(state));
                world.method_8396(player, pos, class_3417.field_29543, class_3419.field_15245, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @Override
    protected boolean adjacentAutoConnect(class_1937 world, class_2338 adjPos, class_2680 adjState, class_2680 hereState, class_2350 direction) {
        class_2248 class_22482 = adjState.method_26204();
        if (class_22482 instanceof FluidPipe) {
            FluidPipe pipe = (FluidPipe)class_22482;
            if (this.canConnectTo(hereState, adjState, direction.method_10153(), world, adjPos, true)) {
                int adjConnections = pipe.countConnections(adjState);
                return adjConnections <= 1 || pipe instanceof AbstractAxialFluidPipe;
            }
        }
        return adjState.method_26204() instanceof PumpBlock && ((class_2350)adjState.method_11654((class_2769)PumpBlock.field_10927)).method_10166() == direction.method_10166();
    }

    @Override
    public boolean canConnectTo(class_2680 hereState, class_2680 toState, class_2350 toFace, class_1937 world, class_2338 toPos, boolean newConnection) {
        class_2248 class_22482 = toState.method_26204();
        if (class_22482 instanceof FluidPipe) {
            FluidPipe otherPipe = (FluidPipe)class_22482;
            return this.col.matches(otherPipe.getCol(world, toPos, toState)) && otherPipe.connectInDirection((class_1922)world, toPos, toState, toFace) && (newConnection || FluidPipe.isConnectedIn((class_1922)world, toPos, toState, toFace));
        }
        class_22482 = toState.method_26204();
        if (class_22482 instanceof PumpBlock) {
            PumpBlock pump = (PumpBlock)class_22482;
            if (((class_2350)toState.method_11654((class_2769)PumpBlock.field_10927)).method_10166() == toFace.method_10166()) {
                return true;
            }
        }
        return newConnection && FluidStorage.SIDED.find(world, toPos, (Object)toFace) != null;
    }

    @Override
    protected boolean handCanChangeConnections(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand, class_2350 changeDirection) {
        return super.handCanChangeConnections(world, pos, state, player, hand, changeDirection);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return NMBlockEntities.FLUID_PIPE.method_11032(pos, state);
    }

    @Override
    public FluidPipe.PipeCol getCol(class_1937 world, class_2338 pos, class_2680 blockState) {
        return this.col;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return MiscUtil.checkType(type, NMBlockEntities.FLUID_PIPE, (world1, pos, state1, blockEntity) -> blockEntity.tick(), null, world);
    }

    @Environment(value=EnvType.CLIENT)
    public static int getTint(class_2680 state, class_1920 world, class_2338 pos, int index) {
        class_2248 class_22482;
        if (index == 1 && (class_22482 = state.method_26204()) instanceof FluidPipeBlock) {
            FluidPipeBlock fluidPipeBlock = (FluidPipeBlock)class_22482;
            int col = fluidPipeBlock.col.hexCode();
            Color first = Color.ofOpaque((int)col);
            Color second = Color.ofOpaque((int)8669999);
            int d = 120;
            int d1 = 255 - d;
            Color mixed = Color.ofRGB((int)((d * first.getRed() + d1 * second.getRed()) / 255), (int)((d * first.getGreen() + d1 * second.getGreen()) / 255), (int)((d * first.getBlue() + d1 * second.getBlue()) / 255));
            return mixed.getColor();
        }
        return 0xFFFFFF;
    }

    @Environment(value=EnvType.CLIENT)
    public static int getItemTint(class_1799 stack, int i) {
        class_1747 blockItem;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof FluidPipeBlock) {
            FluidPipeBlock fluidPipeBlock = (FluidPipeBlock)class_17922;
            return fluidPipeBlock.col.hexCode();
        }
        return 0xFFFFFF;
    }
}

