/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.item_transport.entity;

import com.google.common.collect.Streams;
import com.neep.meatlib.util.RedstoneMode;
import com.neep.neepmeat.api.storage.DynamicLazyBlockApiCache;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.item.filter.FilterList;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.block.item_transport.entity.ItemPipeBlockEntity;
import com.neep.neepmeat.transport.block.item_transport.machine.AdvancedEjectorBlock;
import com.neep.neepmeat.transport.block.item_transport.machine.ItemEjector;
import com.neep.neepmeat.transport.item_network.ItemInPipe;
import com.neep.neepmeat.transport.item_network.ItemPipeVertexImpl;
import com.neep.neepmeat.transport.item_network.PipeRouteFinder;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class AdvancedEjectorBlockEntity
extends ItemPipeBlockEntity
implements ItemEjector {
    protected final LazyBlockApiCache<Storage<ItemVariant>, class_2350> extractionCache = this.addListener(DynamicLazyBlockApiCache.facing(ItemStorage.SIDED, (class_2586)this, () -> (class_2350)this.method_11010().method_11654((class_2769)AdvancedEjectorBlock.FACING)));
    protected int counter;
    protected FilterList filterList = new FilterList(2, this::method_5431);
    private boolean roundRobin;
    private int ejectAmount = 16;
    private int period = 10;
    private int roundRobinIndex;
    private RedstoneMode redstoneMode = RedstoneMode.ACTIVE_WITH;
    private boolean active;

    public AdvancedEjectorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, Vertex::new);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.counter <= 0 && this.active) {
            this.tryTransfer();
            this.counter = this.period;
        }
        this.counter = Math.max(0, this.counter - 1);
        super.serverTick(world, pos, state);
    }

    protected void tryTransfer() {
        Storage<ItemVariant> storage = this.extractionCache.find();
        if (storage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                boolean inserted;
                StorageView<ItemVariant> matchingView = this.findResource(storage);
                if (matchingView == null || matchingView.isResourceBlank()) {
                    return;
                }
                class_2350 in = this.extractionCache.ctx().method_10153();
                ItemVariant resource = (ItemVariant)matchingView.getResource();
                long extractable = matchingView.getAmount();
                PipeRouteFinder.Operation result = new PipeRouteFinder((class_3218)this.field_11863, this.field_11867).run((ResourceAmount<ItemVariant>)new ResourceAmount((Object)resource, Math.min((long)this.ejectAmount, extractable)), s -> s != storage, in, (TransactionContext)transaction);
                long canRoute = Math.min((long)this.ejectAmount, result.maxAmount());
                long extracted = matchingView.extract((Object)resource, canRoute, (TransactionContext)transaction);
                ItemInPipe item = new ItemInPipe(resource, (int)extracted);
                class_2350 out = ((ItemPipe)this.method_11010().method_26204()).getOutputDirection(item, this.field_11867, this.method_11010(), this.field_11863, in, this, !this.vertex.canSimplify(), (TransactionContext)transaction);
                if (extracted > 0L && (inserted = this.insert(item, in, out))) {
                    transaction.commit();
                    return;
                }
                transaction.abort();
            }
        }
    }

    @Nullable
    private StorageView<ItemVariant> findResource(Storage<ItemVariant> storage) {
        if (this.roundRobin) {
            if (storage instanceof InventoryStorage) {
                InventoryStorage inventoryStorage = (InventoryStorage)storage;
                int size = inventoryStorage.getSlotCount();
                int i = 0;
                do {
                    this.roundRobinIndex = class_3532.method_15340((int)((this.roundRobinIndex + 1) % size), (int)0, (int)size);
                    SingleSlotStorage view = inventoryStorage.getSlot(this.roundRobinIndex);
                    if (view.isResourceBlank() || !this.filterList.matches((ItemVariant)view.getResource())) continue;
                    return view;
                } while (++i < size);
            } else {
                List views = Streams.stream(storage).toList();
                int size = views.size();
                int i = 0;
                do {
                    this.roundRobinIndex = class_3532.method_15340((int)((this.roundRobinIndex + 1) % size), (int)0, (int)size);
                    StorageView view = (StorageView)views.get(this.roundRobinIndex);
                    if (view.isResourceBlank() || !this.filterList.matches((ItemVariant)view.getResource())) continue;
                    return view;
                } while (++i < size);
            }
        } else {
            for (StorageView view : storage.nonEmptyViews()) {
                if (!this.filterList.matches((ItemVariant)view.getResource())) continue;
                return view;
            }
        }
        return null;
    }

    private boolean insert(ItemInPipe item, class_2350 in, class_2350 out) {
        if (this.items.size() < MAX_ITEMS) {
            item.reset(in, out, this.field_11863.method_8510());
            this.items.add(item);
            return true;
        }
        return false;
    }

    public FilterList getFilters() {
        return this.filterList;
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.filterList.readNbt(tag);
        this.roundRobin = tag.method_10577("round_robin");
        this.ejectAmount = tag.method_10550("eject_amount");
        this.period = tag.method_10550("period");
        this.redstoneMode = RedstoneMode.values()[tag.method_10550("redstone_mode")];
        this.roundRobinIndex = tag.method_10550("round_robin_index");
        this.active = tag.method_10577("active");
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.filterList.writeNbt(tag);
        tag.method_10556("round_robin", this.roundRobin);
        tag.method_10569("eject_amount", this.ejectAmount);
        tag.method_10569("period", this.period);
        tag.method_10569("redstone_mode", this.redstoneMode.ordinal());
        tag.method_10569("round_robin_index", this.roundRobinIndex);
        tag.method_10556("active", this.active);
    }

    @Override
    public boolean roundRobin() {
        return this.roundRobin;
    }

    @Override
    public int amount() {
        return this.ejectAmount;
    }

    @Override
    public int period() {
        return this.period;
    }

    @Override
    public RedstoneMode redstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void update(boolean roundRobin, int amount, int period, RedstoneMode redstoneMode) {
        this.roundRobin = roundRobin;
        this.ejectAmount = class_3532.method_15340((int)amount, (int)0, (int)64);
        this.period = class_3532.method_15340((int)period, (int)10, (int)100);
        this.redstoneMode = redstoneMode;
        this.method_5431();
        this.updateRedstone(this.field_11863.method_49803(this.field_11867));
    }

    public void updateRedstone(boolean receivingRedstonePower) {
        this.active = this.redstoneMode.active(receivingRedstonePower);
    }

    private static class Vertex
    extends ItemPipeVertexImpl {
        public Vertex(class_2586 parent) {
            super(parent);
        }

        @Override
        public boolean canSimplify() {
            return false;
        }
    }
}

