/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.client.screen;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.widget.IntNumberTextField;
import com.neep.neepmeat.client.screen.NMTextField;
import com.neep.neepmeat.client.screen.button.NMButtonWidget;
import com.neep.neepmeat.network.ScreenPropertyC2SPacket;
import com.neep.neepmeat.transport.block.fluid_transport.entity.FluidUnit;
import com.neep.neepmeat.transport.screen.LimiterValveScreenHandler;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class LimiterValveScreen
extends class_465<LimiterValveScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("neepmeat", "textures/gui/limiter_valve.png");
    protected static final class_2561 RATE = class_2561.method_43471((String)"screen.neepmeat.limiter_valve.text.rate");
    protected static final class_2561 UNIT = class_2561.method_43471((String)"screen.neepmeat.limiter_valve.text.unit");
    protected static final class_2561 DROPLET_MODE = class_2561.method_43471((String)"screen.neepmeat.limiter_valve.text.droplet");
    protected static final class_5250 DROPLET_MODE_INFO = class_2561.method_43471((String)"screen.neepmeat.limiter_valve.text.droplet_info").method_27692(class_124.field_1080);
    protected static final class_2561 MB_MODE = class_2561.method_43471((String)"screen.neepmeat.limiter_valve.text.mb");
    protected static final class_5250 MB_MODE_INFO = class_2561.method_43471((String)"screen.neepmeat.limiter_valve.text.mb_info").method_27692(class_124.field_1080);
    protected static final class_2561 EJ_MODE = class_2561.method_43471((String)"screen.neepmeat.limiter_valve.text.ej_t");
    protected static final class_5250 EJ_MODE_INFO = class_2561.method_43471((String)"screen.neepmeat.limiter_valve.text.ej_t_info").method_27692(class_124.field_1080);
    protected NMTextField textField;

    public LimiterValveScreen(LimiterValveScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 176;
        this.field_2779 = 87;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25267 = 29;
        int textFieldWidth = 54;
        int buttonWidth = 60;
        int spacer = 6;
        int buttonHeight = 20;
        int buttonX = this.field_2776 + (this.field_2792 - (textFieldWidth + spacer + buttonWidth)) / 2;
        int buttonY = this.field_2800 + (this.field_2779 - buttonHeight) / 2;
        int textFieldX = buttonX + buttonWidth + spacer;
        this.textField = new IntNumberTextField(this.field_22793, textFieldX, buttonY, textFieldWidth, buttonHeight, (class_2561)class_2561.method_43473(), c -> {}, 0, Integer.MAX_VALUE, 10, 100){

            @Override
            public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
                super.method_25394(context, mouseX, mouseY, delta);
                if (this.method_25405(mouseX, mouseY)) {
                    context.method_51438(this.textRenderer, RATE, mouseX, mouseY);
                }
            }
        }.drawFancyBackground(true);
        this.textField.setText(Integer.toString(((LimiterValveScreenHandler)this.field_2797).getProperty(0)));
        this.textField.setChangedListener(s -> {
            int parsed = !s.isEmpty() && s.matches("[0-9]*") ? Integer.parseInt(s) : 0;
            ClientPlayNetworking.send((class_2960)ScreenPropertyC2SPacket.ID, (class_2540)ScreenPropertyC2SPacket.Client.create(0, parsed));
        });
        this.method_37063(this.textField);
        this.method_37063(new NMButtonWidget(buttonX, buttonY, buttonWidth, buttonHeight, this.getButtonText(), button -> {}){

            public void method_25306() {
                super.method_25306();
                FluidUnit oldMode = ((LimiterValveScreenHandler)LimiterValveScreen.this.field_2797).getMode();
                FluidUnit newMode = FluidUnit.values()[(oldMode.ordinal() + 1) % FluidUnit.values().length];
                ((LimiterValveScreenHandler)LimiterValveScreen.this.field_2797).setMode(newMode);
                LimiterValveScreen.this.updateText(oldMode, newMode);
                this.method_25355(LimiterValveScreen.this.getButtonText());
                ((LimiterValveScreenHandler)LimiterValveScreen.this.field_2797).setMode(newMode);
            }

            public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
                super.method_25394(context, mouseX, mouseY, delta);
                if (this.method_25405(mouseX, mouseY)) {
                    context.method_51434(LimiterValveScreen.this.field_22793, LimiterValveScreen.this.getButtonTooltip(), this.x(), this.y() + this.h() + 16);
                }
            }
        });
    }

    protected class_2561 getButtonText() {
        return switch (((LimiterValveScreenHandler)this.field_2797).getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case FluidUnit.DROPLETS -> DROPLET_MODE;
            case FluidUnit.MILLIBUCKETS -> MB_MODE;
            case FluidUnit.EJ_T -> EJ_MODE;
        };
    }

    protected List<class_2561> getButtonTooltip() {
        return List.of(UNIT, switch (((LimiterValveScreenHandler)this.field_2797).getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case FluidUnit.DROPLETS -> DROPLET_MODE_INFO;
            case FluidUnit.MILLIBUCKETS -> MB_MODE_INFO;
            case FluidUnit.EJ_T -> EJ_MODE_INFO;
        });
    }

    protected void updateText(FluidUnit oldMode, FluidUnit newMode) {
        if (oldMode != newMode) {
            String oldText = this.textField.text();
            int parsed = !oldText.isEmpty() && oldText.matches("[0-9]*") ? Integer.parseInt(oldText) : 0;
            int newValue = LimiterValveScreen.toUnit(LimiterValveScreen.toDroplets(parsed, oldMode), newMode);
            this.textField.setText(String.valueOf(newValue));
        }
    }

    public static int toDroplets(int value, FluidUnit unit) {
        return switch (unit) {
            default -> throw new IncompatibleClassChangeError();
            case FluidUnit.DROPLETS -> value;
            case FluidUnit.MILLIBUCKETS -> value * 81;
            case FluidUnit.EJ_T -> value / 2;
        };
    }

    public static int toUnit(int droplets, FluidUnit unit) {
        return switch (unit) {
            default -> throw new IncompatibleClassChangeError();
            case FluidUnit.DROPLETS -> droplets;
            case FluidUnit.MILLIBUCKETS -> droplets / 81;
            case FluidUnit.EJ_T -> droplets * 2;
        };
    }

    public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.method_2380(matrices, mouseX, mouseY);
    }

    protected void method_2389(class_332 matrices, float delta, int mouseX, int mouseY) {
        int i = this.field_2776;
        int j = (this.field_22790 - this.field_2779) / 2;
        matrices.method_25302(TEXTURE, i, j, 0, 0, this.field_2792, this.field_2779);
    }

    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        super.method_2383(slot, slotId, button, actionType);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return super.method_25401(mouseX, mouseY, amount);
    }

    protected void method_2388(class_332 matrices, int mouseX, int mouseY) {
        GUIUtil.drawText(matrices, this.field_22793, this.field_22785, (float)this.field_25269, (float)this.field_25268, 0x404040, false);
    }
}

