/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.util;

import com.neep.neepmeat.item.FluidComponentItem;
import com.neep.neepmeat.transport.api.pipe.FluidPipe;
import com.neep.neepmeat.util.FilterUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class ItemUtil {
    public static boolean containsResource(List<StorageView<ItemVariant>> list, ItemVariant stack) {
        for (StorageView<ItemVariant> patternStack : list) {
            if (!((ItemVariant)patternStack.getResource()).equals(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(List<StorageView<ItemVariant>> list, StorageView<ItemVariant> observedView, FilterUtils.Filter filter) {
        for (StorageView<ItemVariant> patternStack : list) {
            if (!((ItemVariant)patternStack.getResource()).equals(observedView.getResource()) || !filter.test(observedView.getAmount(), patternStack.getAmount())) continue;
            return true;
        }
        return false;
    }

    public static boolean notBlank(StorageView<ItemVariant> view) {
        return !view.isResourceBlank();
    }

    public static boolean singleVariantInteract(class_1657 player, class_1268 hand, SingleVariantStorage<ItemVariant> storage) {
        class_1799 stack = player.method_5998(hand);
        try (Transaction transaction = Transaction.openOuter();){
            if ((storage.isResourceBlank() || ((ItemVariant)storage.getResource()).matches(stack)) && !stack.method_7960()) {
                long inserted = storage.insert((TransferVariant)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
                stack.method_7934((int)inserted);
                transaction.commit();
                boolean bl = true;
                return bl;
            }
            if (!(!stack.method_7960() && ((ItemVariant)storage.getResource()).matches(stack) || storage.isResourceBlank())) {
                class_1799 giveStack = ((ItemVariant)storage.getResource()).toStack((int)storage.getAmount());
                player.method_7270(giveStack);
                storage.extract((TransferVariant)((ItemVariant)storage.getResource()), storage.getAmount(), (TransactionContext)transaction);
                transaction.commit();
                boolean bl = true;
                return bl;
            }
            transaction.abort();
        }
        return false;
    }

    public static <T extends TransferVariant<?>> Optional<Long> totalAmount(Storage<T> storage, T resource, Transaction transaction) {
        return StreamSupport.stream(storage.spliterator(), false).filter(view -> ((TransferVariant)view.getResource()).equals(resource)).map(StorageView::getAmount).reduce(Long::sum);
    }

    public static boolean playerHoldingPipe(class_1657 player, class_1268 hand) {
        class_1747 blockItem;
        class_1792 class_17922 = player.method_5998(hand).method_7909();
        return class_17922 instanceof class_1747 && ((blockItem = (class_1747)class_17922).method_7711() instanceof FluidPipe || blockItem instanceof FluidComponentItem);
    }

    public static boolean checkFluidComponent(class_1792 item) {
        class_1747 bi;
        return item instanceof class_1747 && (bi = (class_1747)item) instanceof FluidComponentItem;
    }
}

