/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.api.plc.PLCCols;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class TooltipHelper {
    private static final TooltipHelper INSTANCE = new TooltipHelper(true, PLCCols.TEXT.col, false);
    private final boolean offset;
    private final int col;
    private final boolean forceLeft;
    private final class_327 textRenderer;
    private final class_310 client = class_310.method_1551();

    public TooltipHelper(boolean offset, int col, boolean forceLeft, class_327 textRenderer) {
        this.offset = offset;
        this.col = col;
        this.forceLeft = forceLeft;
        this.textRenderer = textRenderer;
    }

    public TooltipHelper(boolean offset, int col, boolean forceLeft) {
        this(offset, col, forceLeft, class_310.method_1551().field_1772);
    }

    public static TooltipHelper get() {
        return INSTANCE;
    }

    public void draw(class_332 context, int x, int y, List<class_2561> texts) {
        this.renderTooltipComponents(context, texts.stream().map(t -> class_5684.method_32662((class_5481)t.method_30937())).collect(Collectors.toList()), this.offset, x, y, 0, this.col, this.forceLeft);
    }

    public void drawOrdered(class_332 context, int x, int y, List<class_5481> texts, int maxWidth) {
        this.renderTooltipComponents(context, texts.stream().map(class_5684::method_32662).collect(Collectors.toList()), this.offset, x, y, maxWidth, this.col, this.forceLeft);
    }

    public void drawOrdered(class_332 context, int x, int y, List<class_5481> texts) {
        this.drawOrdered(context, x, y, texts, 0);
    }

    public void renderTooltipComponents(class_332 context, List<class_5684> components, boolean offset, int x, int y, int maxWidth, int col, boolean forceLeft) {
        class_4587 matrices = context.method_51448();
        if (offset) {
            x += 12;
            y -= 12;
        }
        if (components.isEmpty()) {
            return;
        }
        int maxHeight = components.size() == 1 ? -2 : 0;
        for (class_5684 tooltipComponent : components) {
            int componentWidth = tooltipComponent.method_32664(this.textRenderer);
            if (componentWidth > maxWidth) {
                maxWidth = componentWidth;
            }
            maxHeight += tooltipComponent.method_32661();
        }
        if (forceLeft) {
            x -= maxWidth + (offset ? 4 : 2);
        }
        if (x + maxWidth > this.width()) {
            x -= maxWidth + (offset ? 28 : 2);
        }
        if (y + maxHeight + 3 > this.height()) {
            y = this.height() - maxHeight - 3;
        }
        if (y < 0) {
            y = 0;
        }
        if (x < 0) {
            x = 0;
        }
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 400.0f);
        RenderSystem.setShader(class_757::method_34540);
        context.method_25294(x, y, x + maxWidth + 2, y + maxHeight + 2, -1879048192);
        GUIUtil.drawHorizontalLine1(context, x, x + maxWidth + 2, y, col);
        GUIUtil.drawHorizontalLine1(context, x, x + maxWidth + 2, y + maxHeight + 2, col);
        GUIUtil.drawVerticalLine1(context, x + maxWidth + 2, y, y + maxHeight + 2, col);
        GUIUtil.drawVerticalLine1(context, x, y, y + maxHeight + 2, col);
        RenderSystem.disableBlend();
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        matrices.method_22904(0.0, 0.0, 400.0);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        int yAdvance = y + 2;
        for (class_5684 tooltipComponent2 : components) {
            tooltipComponent2.method_32665(this.textRenderer, x + 2, yAdvance, matrix4f, immediate);
            yAdvance += tooltipComponent2.method_32661();
        }
        immediate.method_22993();
        matrices.method_22909();
        yAdvance = y;
        for (int index = 0; index < components.size(); ++index) {
            class_5684 tooltipComponent2;
            tooltipComponent2 = components.get(index);
            tooltipComponent2.method_32666(this.textRenderer, x, yAdvance, context);
            yAdvance += tooltipComponent2.method_32661() + (index == 0 ? 2 : 0);
        }
    }

    private int width() {
        return this.client.method_22683().method_4486();
    }

    private int height() {
        return this.client.method_22683().method_4502();
    }
}

