/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.machine;

import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.machine.motor.MotorEntity;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public interface MotorisedBlock {
    public static final BlockApiLookup<MotorisedBlock, Void> LOOKUP = BlockApiLookup.get((class_2960)new class_2960("neepmeat", "motorised_block"), MotorisedBlock.class, Void.class);

    public boolean motorTick(MotorEntity var1);

    public void setInputPower(float var1);

    default public boolean canConnect(class_2350 direction) {
        return true;
    }

    default public void onMotorRemoved() {
    }

    default public float getLoadTorque() {
        return 300.0f;
    }

    public static class Diagnostics {
        protected class_2487 nbt = new class_2487();

        public static Diagnostics insufficientPower(boolean problem, float power, float minPower) {
            class_5250 title = class_2561.method_43471((String)"message.neepmeat.insufficient_power");
            class_5250 message = class_2561.method_43469((String)"message.neepmeat.insufficient_power_2", (Object[])new Object[]{class_2561.method_43470((String)PowerUtils.POWER_FORMAT.format(PowerUtils.perUnitToAbsolute(power))).method_10852(PowerUtils.POWER_UNIT), class_2561.method_43470((String)PowerUtils.POWER_FORMAT.format(PowerUtils.perUnitToAbsolute(minPower))).method_10852(PowerUtils.POWER_UNIT)});
            return new Diagnostics(problem, (class_2561)title, (class_2561)message);
        }

        public Diagnostics(boolean problem, class_2561 title, class_2561 message) {
            this.nbt.method_10556("problem", problem);
            this.nbt.method_10582("title", title.getString());
            this.nbt.method_10582("message", message.getString());
        }

        public Diagnostics(class_2487 nbt) {
            this.nbt = nbt;
        }

        public boolean problem() {
            return this.nbt.method_10577("problem");
        }

        public class_2561 title() {
            return class_2561.method_30163((String)this.nbt.method_10558("title"));
        }

        public class_2561 message() {
            return class_2561.method_30163((String)this.nbt.method_10558("message"));
        }

        public class_2487 nbt() {
            return this.nbt;
        }
    }

    public static interface DiagnosticsProvider {
        public static final BlockApiLookup<DiagnosticsProvider, Void> LOOKUP = BlockApiLookup.get((class_2960)new class_2960("neepmeat", "machine_diagnostics"), DiagnosticsProvider.class, Void.class);

        @Nullable
        public Diagnostics getDiagnostics();

        public static void init() {
            LOOKUP.registerFallback((world, pos, state, blockEntity, context) -> {
                if (blockEntity instanceof DiagnosticsProvider) {
                    DiagnosticsProvider d = (DiagnosticsProvider)blockEntity;
                    return d;
                }
                return null;
            });
        }
    }
}

