/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.plc.instruction;

import com.google.common.collect.Lists;
import com.neep.neepmeat.api.plc.instruction.ArgumentPredicate;
import com.neep.neepmeat.api.plc.instruction.InstructionBuilder;
import com.neep.neepmeat.api.plc.instruction.InstructionException;
import com.neep.neepmeat.api.plc.instruction.SimpleInstructionProvider;
import com.neep.neepmeat.neepasm.program.KeyValue;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionBuilderFactory;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1937;

public class PredicatedInstructionBuilder
implements InstructionBuilder {
    private final List<Argument> arguments = Lists.newArrayList();
    private final SimpleInstructionProvider provider;
    private final class_1937 world;
    private final Consumer<Instruction> finished;
    private final List<ArgumentPredicate> predicates;

    PredicatedInstructionBuilder(SimpleInstructionProvider provider, class_1937 world, Consumer<Instruction> finished, List<ArgumentPredicate> predicates) {
        this.provider = provider;
        this.world = world;
        this.finished = finished;
        this.predicates = predicates;
    }

    @Override
    public InstructionBuilder argument(Argument argument) throws InstructionException {
        this.predicates.get(this.arguments.size()).test(this.world, argument);
        this.arguments.add(argument);
        if (this.isComplete()) {
            this.finished.accept(this.build());
            this.arguments.clear();
        }
        return this;
    }

    @Override
    public InstructionBuilder keyValue(KeyValue kv) throws InstructionException {
        return this;
    }

    @Override
    public boolean isComplete() {
        return this.arguments.size() == this.provider.maxArguments();
    }

    @Override
    public Instruction build() {
        return this.provider.create(this.world, this.arguments);
    }

    @Override
    public int argumentCount() {
        return this.arguments.size();
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    implements InstructionBuilderFactory {
        private final List<ArgumentPredicate> predicates = Lists.newArrayList();

        public Builder arg(ArgumentPredicate predicate) {
            this.predicates.add(predicate);
            return this;
        }

        @Override
        public InstructionBuilder create(SimpleInstructionProvider provider, class_1937 world, Consumer<Instruction> finished) {
            if (provider.maxArguments() != this.predicates.size()) {
                throw new IllegalStateException(provider.getShortName() + ": Argument and predicate count do not match. Fix your code!");
            }
            return new PredicatedInstructionBuilder(provider, world, finished, this.predicates);
        }
    }
}

