/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.plc;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.TooltipHelper;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.api.plc.recipe.ManufactureStep;
import com.neep.neepmeat.api.plc.recipe.Workpiece;
import com.neep.neepmeat.client.plc.PLCHudRenderer;
import com.neep.neepmeat.client.plc.PLCMotionController;
import com.neep.neepmeat.client.screen.plc.LanguageMode;
import com.neep.neepmeat.client.screen.plc.PLCScreenButton;
import com.neep.neepmeat.client.screen.plc.PLCScreenEditorState;
import com.neep.neepmeat.client.screen.plc.PLCScreenShellState;
import com.neep.neepmeat.client.screen.plc.PLCScreenState;
import com.neep.neepmeat.client.screen.plc.RecordMode;
import com.neep.neepmeat.client.screen.tablet.GuideMainScreen;
import com.neep.neepmeat.guide.GuideNode;
import com.neep.neepmeat.guide.GuideReloadListener;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.item.ProjectorItem;
import com.neep.neepmeat.network.plc.PLCSyncAction;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.screen.PLCScreenHandler;
import com.neep.neepmeat.util.MiscUtil;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1041;
import net.minecraft.class_1058;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3936;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;

public class PLCProgramScreen
extends class_437
implements class_3936<PLCScreenHandler> {
    public static final class_2960 WIDGETS = new class_2960("neepmeat", "textures/gui/widget/plc_widgets.png");
    public static final class_2960 VIGNETTE = new class_2960("neepmeat", "textures/gui/plc_robot_vignette.png");
    protected final PLCScreenEditorState editor;
    protected final PLCScreenShellState shell;
    private final PLCScreenHandler handler;
    private final List<class_2561> tooltipText = Lists.newArrayList();
    protected PLCScreenState state;
    private double mouseX;
    private double mouseY;
    private RecordMode mode;

    public PLCProgramScreen(PLCScreenHandler handler, class_1661 playerInventory, class_2561 unused) {
        super(unused);
        this.handler = handler;
        this.editor = new PLCScreenEditorState(this);
        this.shell = new PLCScreenShellState(this);
        this.state = this.shell;
        this.mode = handler.getMode();
        handler.compileMessageS2C.receiver(this.editor::setCompileMessage);
        handler.updateStackS2C.receiver(handler.getPlc()::updateVariableStack);
        handler.updateMemoryS2C.receiver(handler.getPlc()::updateMemory);
    }

    @Nullable
    public static class_2680 getWallState(class_1937 world, class_4184 camera) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        float width = 0.8f;
        for (int i = 0; i < 8; ++i) {
            class_243 camPos = camera.method_19326();
            double d = camPos.field_1352 + (double)(((float)((i >> 0) % 2) - 0.5f) * width * 0.8f);
            double e = camPos.field_1351 + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double f = camPos.field_1350 + (double)(((float)((i >> 2) % 2) - 0.5f) * width * 0.8f);
            mutable.method_10102(d, e, f);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (blockState.method_26217() == class_2464.field_11455 || !blockState.method_26230((class_1922)world, (class_2338)mutable)) continue;
            return blockState;
        }
        return null;
    }

    private static void makeEntityTooltip(@Nullable class_1297 entity, List<class_2561> tooltip) {
        if (entity == null) {
            return;
        }
        tooltip.add(entity.method_5476());
        Workpiece workpiece = (Workpiece)NMComponents.WORKPIECE.getNullable((Object)entity);
        if (workpiece != null) {
            for (ManufactureStep<?> step : workpiece.getSteps()) {
                step.appendText(tooltip);
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        this.editor.init(this.field_22789, this.field_22790);
        this.shell.init(this.field_22789, this.field_22790);
        if (this.mode == RecordMode.EDIT) {
            this.method_37063(this.editor);
            this.editor.setDimensions(this.field_22789, this.field_22790);
            this.method_37063(new ModeSwitchButton(this.field_22789 - 17, 1));
            this.method_37063(new StopButton(this.field_22789 - 34, 1, class_2561.method_30163((String)"Stop (CTRL+T)")));
            this.method_37063(new StepButton(this.field_22789 - 51, 1, class_2561.method_30163((String)"Step (CTRL+F)")));
            this.method_37063(new RunButton(this.field_22789 - 68, 1, class_2561.method_30163((String)"Run/Pause (CTRL+R)")));
            this.method_37063(new CompileButton(this.field_22789 - 85, 1, class_2561.method_30163((String)"Compile (CTRL+S)")));
            this.method_37063(new LanguageButton(this.field_22789 - 102 - 32, 1, (class_2561)class_2561.method_43473()));
            this.state = this.editor;
        } else {
            this.method_37063(this.shell);
            this.method_37063(new ModeSwitchButton(this.field_22789 - 17, 1));
            this.method_37063(new StopButton(this.field_22789 - 34, 1, class_2561.method_30163((String)"Stop")));
            this.state = this.shell;
        }
    }

    public void method_25393() {
        super.method_25393();
        this.tickTooltip(this.mouseX, this.mouseY);
        this.editor.tick();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.state.isSelected() || keyCode == 256) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        this.state.onKeyPressed(keyCode, scanCode, modifiers);
        return true;
    }

    public boolean method_25400(char chr, int modifiers) {
        return super.method_25400(chr, modifiers);
    }

    public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        class_2680 wallState = PLCProgramScreen.getWallState((class_1937)this.field_22787.field_1687, this.field_22787.field_1773.method_19418());
        if (wallState != null) {
            class_1058 sprite = this.field_22787.method_1541().method_3351().method_3339(wallState);
            PLCProgramScreen.renderInWallOverlay(sprite, matrices.method_51448(), this.field_22789, this.field_22790);
        } else {
            PLCProgramScreen.drawScreenTexture(matrices.method_51448(), VIGNETTE, 0.0f, 0.0f, 1.0f, 1.0f, 0.9f, this.field_22789, this.field_22790);
        }
        if (!this.tooltipText.isEmpty()) {
            TooltipHelper.get().draw(matrices, mouseX, mouseY, this.tooltipText);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public static void drawScreenTexture(class_4587 matrices, class_2960 texture, float u0, float v0, float u1, float v1, float light, int x1, int y1) {
        float x0 = 0.0f;
        float y0 = 0.0f;
        float z = 0.0f;
        Matrix4f matrix = matrices.method_23760().method_23761();
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, x0, (float)y1, z).method_22915(light, light, light, 1.0f).method_22913(u0, v1).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, z).method_22915(light, light, light, 1.0f).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, y0, z).method_22915(light, light, light, 1.0f).method_22913(u1, v0).method_1344();
        bufferBuilder.method_22918(matrix, x0, y0, z).method_22915(light, light, light, 1.0f).method_22913(u0, v0).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void renderInWallOverlay(class_1058 sprite, class_4587 matrices, int width, int height) {
        float x0 = 0.0f;
        float y0 = 0.0f;
        float z = 0.0f;
        RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
        RenderSystem.setShader(class_757::method_34541);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        float l = sprite.method_4594();
        float m = sprite.method_4577();
        float n = sprite.method_4593();
        float o = sprite.method_4575();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        bufferBuilder.method_22918(matrix4f, x0, (float)height, z).method_22915(0.1f, 0.1f, 0.1f, 1.0f).method_22913(m, o).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)width, (float)height, z).method_22915(0.1f, 0.1f, 0.1f, 1.0f).method_22913(l, o).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)width, y0, z).method_22915(0.1f, 0.1f, 0.1f, 1.0f).method_22913(l, n).method_1344();
        bufferBuilder.method_22918(matrix4f, x0, y0, z).method_22915(0.1f, 0.1f, 0.1f, 1.0f).method_22913(m, n).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    private void tickTooltip(double mouseX, double mouseY) {
        this.tooltipText.clear();
        class_3965 result = this.raycastClick(mouseX, mouseY, 15.0);
        if (result.method_17783() == class_239.class_240.field_1332) {
            PLCHudRenderer.HIT_RESULT = result;
            MutateInPlace mip1 = (MutateInPlace)MutateInPlace.ITEM.find((class_1937)this.field_22787.field_1687, result.method_17777(), null);
            MutateInPlace mip2 = (MutateInPlace)MutateInPlace.ENTITY.find((class_1937)this.field_22787.field_1687, result.method_17777(), null);
            if (mip1 != null) {
                class_1799 stack = (class_1799)mip1.get();
                if (stack == null || stack.method_7960()) {
                    return;
                }
                this.tooltipText.addAll(stack.method_7950((class_1657)this.field_22787.field_1724, (class_1836)class_1836.class_1837.field_41070));
            } else if (mip2 != null) {
                PLCProgramScreen.makeEntityTooltip((class_1297)mip2.get(), this.tooltipText);
            }
        } else {
            PLCHudRenderer.HIT_RESULT = null;
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        PLCHudRenderer renderer;
        if ((button == 1 || button == 2) && (renderer = PLCHudRenderer.getInstance()) != null) {
            double sensitivity = 0.4;
            PLCMotionController controller = renderer.getController();
            controller.setPitchYaw((float)class_3532.method_15350((double)((double)controller.getPitch() - deltaY * sensitivity), (double)-90.0, (double)90.0), (float)((double)controller.getYaw() - deltaX * sensitivity));
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        this.method_25395(null);
        return this.handleWorldClick(mouseX, mouseY, button);
    }

    protected boolean handleWorldClick(double mouseX, double mouseY, int button) {
        if (button == 1 || button == 2) {
            return false;
        }
        class_3965 result = this.raycastClick(mouseX, mouseY, 15.0);
        if (result.method_17783() == class_239.class_240.field_1333) {
            return false;
        }
        this.addArgument(result);
        for (int i = 0; i < 15; ++i) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)NMSounds.PLC_SELECT, (float)1.0f));
        }
        return true;
    }

    protected void addArgument(class_3965 result) {
        this.state.argument(new Argument(result.method_17777(), result.method_17780()));
    }

    protected class_3965 raycastClick(double mouseX, double mouseY, double range) {
        class_243 camPos = this.field_22787.field_1773.method_19418().method_19326();
        class_243 farPos = PLCProgramScreen.screenToWorld(mouseX, mouseY, 0.4f);
        class_243 nearPos = PLCProgramScreen.screenToWorld(mouseX, mouseY, 0.0);
        class_243 newFar = nearPos.method_1019(farPos.method_1020(nearPos).method_1029().method_1021(range));
        class_3959 raycastContext = new class_3959(nearPos.method_1019(camPos), newFar.method_1019(camPos), class_3959.class_3960.field_23142, class_3959.class_242.field_1348, (class_1297)this.field_22787.field_1724);
        return this.field_22787.field_1687.method_17742(raycastContext);
    }

    public static class_243 screenToWorld(double mouseX, double mouseY, double z) {
        class_1041 window = class_310.method_1551().method_22683();
        Matrix4d mat = new Matrix4d((Matrix4fc)PLCHudRenderer.PROJECTION).mul(PLCHudRenderer.MODEL_VIEW);
        int[] screenDims = new int[]{0, 0, window.method_4486(), window.method_4502()};
        Vector3d worldPos = mat.unproject(mouseX, (double)window.method_4502() - mouseY, z, screenDims, new Vector3d());
        return new class_243(worldPos.x, worldPos.y, worldPos.z);
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        Optional hovered = this.method_19355(mouseX, mouseY);
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void method_25432() {
        super.method_25432();
        if (this.field_22787.field_1724 != null) {
            this.handler.method_7595((class_1657)this.field_22787.field_1724);
        }
        PLCHudRenderer.leave();
    }

    public void method_25419() {
        super.method_25419();
        this.field_22787.field_1724.method_7346();
        PLCHudRenderer.leave();
    }

    public PLCScreenHandler getScreenHandler() {
        return this.handler;
    }

    public PLCScreenEditorState getEditor() {
        return this.editor;
    }

    public PLCScreenShellState getInteractive() {
        return this.shell;
    }

    public boolean passEvents() {
        return !this.editor.isEditFieldFocused();
    }

    private void changeLanguage(LanguageMode language) {
        this.handler.changeLanguage.emitter().accept(language);
        this.editor.changeLanguage(language);
    }

    class ModeSwitchButton
    extends BaseButton {
        public ModeSwitchButton(int x, int y) {
            super(x, y, (class_2561)class_2561.method_43473());
        }

        public void method_25348(double mouseX, double mouseY) {
            PLCProgramScreen.this.mode = (RecordMode)MiscUtil.cycle((Enum)PLCProgramScreen.this.handler.getMode(), (Enum[])RecordMode.values());
            PLCProgramScreen.this.handler.changeMode.emitter().accept(PLCProgramScreen.this.mode);
            PLCProgramScreen.this.state = PLCProgramScreen.this.mode == RecordMode.IMMEDIATE ? PLCProgramScreen.this.shell : PLCProgramScreen.this.editor;
            PLCProgramScreen.this.method_41843();
        }

        public class_2561 method_25369() {
            return switch (PLCProgramScreen.this.handler.getMode()) {
                default -> throw new IncompatibleClassChangeError();
                case RecordMode.EDIT -> class_2561.method_30163((String)"Edit Mode");
                case RecordMode.IMMEDIATE -> class_2561.method_30163((String)"Interactive Mode: Instructions will be executed immediately");
            };
        }

        @Override
        protected int getU() {
            return switch (PLCProgramScreen.this.handler.getMode()) {
                default -> throw new IncompatibleClassChangeError();
                case RecordMode.EDIT -> 64;
                case RecordMode.IMMEDIATE -> 48;
            };
        }
    }

    class StopButton
    extends BaseButton {
        public StopButton(int x, int y, class_2561 message) {
            super(x, y, message);
        }

        @Override
        protected int getU() {
            return 80;
        }

        @Override
        protected int getYImage(boolean hovered) {
            if (PLCProgramScreen.this.handler.hasProgram() > 0) {
                if (this.method_49606()) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }

        public void method_25348(double mouseX, double mouseY) {
            PLCProgramScreen.this.handler.channel.emitter().apply(PLCSyncAction.STOP);
        }
    }

    class StepButton
    extends BaseButton {
        public StepButton(int x, int y, class_2561 message) {
            super(x, y, message);
        }

        @Override
        protected int getU() {
            return 160;
        }

        public void method_25348(double mouseX, double mouseY) {
            PLCProgramScreen.this.handler.channel.emitter().apply(PLCSyncAction.STEP);
        }
    }

    class RunButton
    extends BaseButton {
        public RunButton(int x, int y, class_2561 message) {
            super(x, y, message);
        }

        @Override
        protected int getU() {
            return PLCProgramScreen.this.handler.isRunning() ? 32 : 16;
        }

        public void method_25348(double mouseX, double mouseY) {
            if (PLCProgramScreen.this.handler.isRunning()) {
                PLCProgramScreen.this.handler.channel.emitter().apply(PLCSyncAction.PAUSE);
            } else {
                PLCProgramScreen.this.handler.channel.emitter().apply(PLCSyncAction.RUN);
            }
        }
    }

    class CompileButton
    extends BaseButton {
        public CompileButton(int x, int y, class_2561 message) {
            super(x, y, message);
        }

        @Override
        protected int getU() {
            return 96;
        }

        public void method_25348(double mouseX, double mouseY) {
            PLCProgramScreen.this.handler.channel.emitter().apply(PLCSyncAction.COMPILE);
        }
    }

    class LanguageButton
    extends PLCScreenButton {
        public LanguageButton(int x, int y, class_2561 message) {
            super(x, y, 48, 16, message);
        }

        @Override
        protected int getU() {
            return 176;
        }

        @Override
        public void renderTooltip(class_332 matrices, int mouseX, int mouseY) {
            TooltipHelper.get().drawOrdered(matrices, mouseX, mouseY, PLCProgramScreen.this.field_22793.method_1728((class_5348)this.method_25369(), 200), 200);
        }

        @Override
        public void method_48579(class_332 matrices, int mouseX, int mouseY, float delta) {
            super.method_48579(matrices, mouseX, mouseY, delta);
            class_327 class_3272 = PLCProgramScreen.this.field_22793;
            class_2561 class_25612 = class_2561.method_30163((String)PLCProgramScreen.this.handler.getLanguage().name());
            float f = (float)this.x() + (float)this.w() / 2.0f;
            float f2 = this.y();
            int n = this.h();
            Objects.requireNonNull(PLCProgramScreen.this.field_22793);
            GUIUtil.drawCenteredText(matrices, class_3272, class_25612, f, f2 + (float)(n - 9) / 2.0f, PLCCols.TEXT.col, true);
        }

        public class_2561 method_25369() {
            return NeepMeat.translationKey("tooltip", "plc.language", PLCProgramScreen.this.handler.getLanguage().name());
        }

        public void method_25348(double mouseX, double mouseY) {
            if (!class_437.method_25442() && !class_437.method_25441()) {
                LanguageMode language = (LanguageMode)MiscUtil.cycle((Enum)PLCProgramScreen.this.handler.getLanguage(), (Enum[])LanguageMode.values());
                PLCProgramScreen.this.changeLanguage(language);
            } else {
                List<GuideNode> path = GuideReloadListener.getInstance().getPath(PLCProgramScreen.this.handler.getLanguage().name().toLowerCase(Locale.ROOT));
                if (path != null) {
                    GuideMainScreen screen = ProjectorItem.Client.openScreen();
                    for (GuideNode node : path) {
                        node.visitScreen(screen);
                    }
                }
            }
        }
    }

    public static abstract class BaseButton
    extends PLCScreenButton {
        public BaseButton(int x, int y, class_2561 message) {
            super(x, y, message);
        }

        @Override
        public void renderTooltip(class_332 matrices, int mouseX, int mouseY) {
            TooltipHelper.get().draw(matrices, mouseX, mouseY, List.of(this.method_25369()));
        }
    }
}

