/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.tablet;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.client.screen.tablet.ContentPane;
import com.neep.neepmeat.client.screen.tablet.GuideArticlePane;
import com.neep.neepmeat.client.screen.tablet.GuideListPane;
import com.neep.neepmeat.client.screen.tablet.GuideScreen;
import com.neep.neepmeat.guide.GuideNode;
import com.neep.neepmeat.guide.GuideReloadListener;
import com.neep.neepmeat.guide.article.Article;
import java.util.Deque;
import java.util.LinkedList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GuideMainScreen
extends class_437
implements GuideScreen {
    public static final class_2960 LOGO_TEXTURE = new class_2960("neepmeat", "textures/gui/tablet/neep.png");
    private int x;
    private int y;
    protected int contentWidth = 340;
    protected int contentHeight = 280;
    protected int animationTicks;
    protected boolean start = true;
    protected final ContentPane leftPane = new GuideListPane(this);
    protected ContentPane rightPane = new GuideArticlePane(this, Article.EMPTY);
    protected final Deque<GuideNode> path;

    public GuideMainScreen() {
        super((class_2561)class_2561.method_43473());
        GuideReloadListener reloadListener = GuideReloadListener.getInstance();
        @Nullable GuideNode root = reloadListener.getRootNode();
        if (root != null) {
            this.path = reloadListener.getPersistentPath();
            if (this.path.isEmpty()) {
                this.push(root);
            }
        } else {
            this.path = new LinkedList<GuideNode>();
        }
    }

    @Override
    public void setRightPane(ContentPane element) {
        this.method_37066(this.rightPane);
        this.rightPane = element;
        this.method_25426();
    }

    @Override
    public void push(GuideNode node) {
        this.path.push(node);
        this.leftPane.method_25426();
    }

    @Override
    public GuideNode pop() {
        GuideNode ret = null;
        if (this.path.size() > 1) {
            ret = this.path.pop();
        }
        this.leftPane.method_25426();
        return ret;
    }

    @Override
    public Deque<GuideNode> getPath() {
        return this.path;
    }

    @Override
    public int getAnimationTicks() {
        return this.animationTicks;
    }

    @Override
    public void openArticle(Article article) {
        this.setRightPane(new GuideArticlePane(this, article));
    }

    public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        matrices.method_51448().method_22903();
        float scale = class_3532.method_37166((float)0.01f, (float)1.0f, (float)(((float)this.animationTicks + delta) / 10.0f));
        matrices.method_51448().method_46416(0.0f, (float)this.field_22790 / 2.0f * (1.0f - scale), 0.0f);
        matrices.method_51448().method_22905(1.0f, scale, 1.0f);
        if (this.animationTicks > 10) {
            super.method_25394(matrices, mouseX, mouseY, delta);
            this.drawLogo(matrices, delta);
        }
        int borderCol = -16742400;
        int offset = 3;
        if (this.animationTicks != 0 && this.animationTicks != 2) {
            GUIUtil.renderBorder(matrices, this.x, this.y, this.contentWidth, this.contentHeight, borderCol, offset);
        }
        matrices.method_51448().method_22909();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.method_19355(mouseX, mouseY).filter(element -> element.method_25401(mouseX, mouseY, amount)).isPresent();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.leftPane.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.rightPane.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256 && this.method_25422()) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.leftPane.method_25400(chr, modifiers)) {
            return true;
        }
        return this.rightPane.method_25400(chr, modifiers);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063(this.leftPane);
        this.method_37063(this.rightPane);
        float windowWidth = this.field_22787.method_22683().method_4486();
        float windowHeight = this.field_22787.method_22683().method_4502();
        float aspectRatio = windowWidth / windowHeight;
        this.contentHeight = (int)(windowHeight - 40.0f);
        this.contentWidth = (int)((float)this.contentHeight * aspectRatio);
        this.x = (this.field_22789 - this.contentWidth) / 2;
        this.y = (this.field_22790 - this.contentHeight) / 2;
        float ratio = 0.4f;
        int leftWidth = (int)(ratio * (float)this.contentWidth);
        int rightWidth = (int)((1.0f - ratio) * (float)this.contentWidth);
        int rightStart = this.x + leftWidth;
        if (this.leftPane != null) {
            this.leftPane.setDimensions(this.x, this.y, leftWidth, this.contentHeight - 26);
            this.leftPane.init(this.field_22787);
        }
        if (this.rightPane != null) {
            this.rightPane.setDimensions(rightStart, this.y, rightWidth, this.contentHeight);
            this.rightPane.init(this.field_22787);
        }
    }

    protected void drawLogo(class_332 matrices, float delta) {
        int logoHeight = 24;
        int logoWidth = 60;
        matrices.method_25290(LOGO_TEXTURE, this.x, this.y + this.contentHeight - logoHeight + 1, 0.0f, 0.0f, logoWidth, logoHeight, logoWidth, 26);
    }

    public void method_25393() {
        ++this.animationTicks;
        this.leftPane.method_25393();
        this.rightPane.method_25393();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25432() {
    }

    public void method_25419() {
        super.method_25419();
    }
}

