/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.enlightenment;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.neep.neepmeat.api.enlightenment.EnlightenmentEvent;
import com.neep.neepmeat.api.enlightenment.EnlightenmentUtil;
import com.neep.neepmeat.api.network.EnlightenmentEventPacket;
import com.neep.neepmeat.enlightenment.PlayerEnlightenmentManager;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.transport.interfaces.IServerWorld;
import dev.onyxstudios.cca.api.v3.component.Component;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class EnlightenmentEventManager {
    public static final class_2960 EMPTY_ID = new class_2960("neepmeat", "empty");
    public static class_2378<EnlightenmentEvent.Factory> EVENTS = FabricRegistryBuilder.createSimple((class_5321)class_5321.method_29180((class_2960)new class_2960("neepmeat", "enlightenment_event"))).buildAndRegister();
    private final Random random = new Random();
    private int counter = 0;

    public static void init() {
        ServerTickEvents.START_WORLD_TICK.register(world -> ((IServerWorld)world).getEnlightenmentEventManager().tick(world));
    }

    public static EnlightenmentEventManager get(class_3218 world) {
        return ((IServerWorld)world).getEnlightenmentEventManager();
    }

    protected void tick(class_3218 world) {
        ++this.counter;
        if (this.counter >= 40) {
            this.chooseEvent(world);
            this.counter = 0;
        }
    }

    protected void chooseEvent(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            float thing = EnlightenmentUtil.getEventProbability((class_1657)player);
            float p = this.random.nextFloat();
            if (!(p < thing)) continue;
            if (EVENTS.method_10204() == 0) {
                return;
            }
            List factories = EVENTS.method_10220().collect(Collectors.toList());
            Collections.shuffle(factories);
            int i = 0;
            while (!((EnlightenmentEvent.Factory)factories.get(i)).willSpawn(world, player)) {
                if (++i < factories.size()) continue;
                return;
            }
            EnlightenmentEvent.Factory factory = (EnlightenmentEvent.Factory)factories.get(i);
            this.spawnFactory(world, player, factory);
        }
    }

    public void spawnFactory(class_3218 world, class_3222 player, EnlightenmentEvent.Factory factory) {
        EnlightenmentEvent event = factory.create(world, player);
        EnlightenmentEventPacket.send(factory, world, player);
        Component component = NMComponents.ENLIGHTENMENT_MANAGER.getNullable((Object)player);
        if (component instanceof PlayerEnlightenmentManager) {
            PlayerEnlightenmentManager manager = (PlayerEnlightenmentManager)component;
            manager.addEvent(event);
        }
        event.spawn();
    }

    static {
        class_2378.method_10230(EVENTS, (class_2960)EMPTY_ID, (Object)new EnlightenmentEvent.Factory(){

            @Override
            public EnlightenmentEvent create(class_3218 world, class_3222 player) {
                return new EnlightenmentEvent(){

                    @Override
                    public void tick() {
                    }

                    @Override
                    public boolean isRemoved() {
                        return true;
                    }
                };
            }

            @Override
            public boolean willSpawn(class_3218 world, class_3222 player) {
                return false;
            }
        });
    }

    public static class Suggestions
    implements SuggestionProvider<class_2168> {
        public CompletableFuture<com.mojang.brigadier.suggestion.Suggestions> getSuggestions(CommandContext<class_2168> commandContext, SuggestionsBuilder suggestionsBuilder) throws CommandSyntaxException {
            for (class_2960 id : EVENTS.method_10235()) {
                suggestionsBuilder.suggest(id.toString());
            }
            return suggestionsBuilder.buildFuture();
        }
    }
}

