/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.entity.worm;

import com.neep.neepmeat.entity.worm.AnimatedWormGoal;
import com.neep.neepmeat.entity.worm.WormAction;
import com.neep.neepmeat.entity.worm.WormEntity;
import com.neep.neepmeat.util.Easing;
import com.neep.neepmeat.util.NMMaths;
import java.util.EnumSet;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class WormBiteGoal
extends AnimatedWormGoal<WormBiteGoal> {
    public static final class_2960 ID = new class_2960("neepmeat", "bite");
    protected final WormEntity parent;
    protected final float range = 16.0f;
    protected final WormAction.Sequence<WormBiteGoal> orientSequence;
    protected final WormAction.Sequence<WormBiteGoal> attackSequence;
    protected final WormAction.Sequence<WormBiteGoal> returnSequence;

    public WormBiteGoal(WormEntity entity) {
        this.parent = entity;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.orientSequence = (action, counter) -> {
            class_1309 target = this.parent.getTarget();
            if (counter > 20) {
                action.setSequence(action.attackSequence);
                return;
            }
            if (target == null) {
                action.setSequence(action.returnSequence);
                return;
            }
            class_243 neutralHead = this.parent.getNeutralHeadPos();
            class_243 neutralToTarget = target.method_19538().method_1020(neutralHead);
            class_243 baseToTarget = target.method_19538().method_1020(this.parent.method_19538()).method_1029();
            class_241 v1 = NMMaths.flattenY(baseToTarget);
            float angle = (float)Math.toDegrees(NMMaths.getAngle(v1));
            this.parent.method_36456(angle);
            double targetRange = Math.min(7.0, baseToTarget.method_1033());
            class_243 headPos = neutralHead.method_1019(baseToTarget.method_1021(targetRange));
            this.parent.lerpHeadPos(counter, 20, headPos);
            class_241 pitchYaw = NMMaths.rectToPol(neutralToTarget);
            this.parent.lerpHeadAngles(counter, 20, pitchYaw.field_1343, pitchYaw.field_1342);
        };
        this.attackSequence = (action, counter) -> {
            if (counter > 20) {
                action.setSequence(action.returnSequence);
                return;
            }
            class_1309 target = this.parent.getTarget();
            if (target == null) {
                action.setSequence(action.returnSequence);
                return;
            }
            class_243 neutralHead = this.parent.getNeutralHeadPos();
            class_243 neutralToTarget = target.method_19538().method_1020(neutralHead);
            double targetRange = Math.min(16.0, neutralToTarget.method_1033());
            class_243 headPos = neutralHead.method_1019(neutralToTarget.method_1029().method_1021(targetRange));
            this.parent.lerpHeadPos(counter, 20, headPos, Easing::easeInBack);
            class_241 pitchYaw = NMMaths.rectToPol(neutralToTarget);
            this.parent.lerpHeadAngles(counter, 20, pitchYaw.field_1343, pitchYaw.field_1342);
        };
        this.returnSequence = (action, counter) -> {
            if (counter > 20) {
                action.markFinished();
                return;
            }
            this.parent.returnHeadToNeutral(counter, 20);
        };
    }

    public boolean method_6264() {
        return this.parent.getTarget() != null && this.parent.method_6051().method_43056();
    }

    @Override
    public void method_6269() {
        this.setSequence(this.orientSequence);
        this.finished = false;
    }
}

