/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.entity.worm;

import com.neep.neepmeat.entity.worm.AnimatedWormGoal;
import com.neep.neepmeat.entity.worm.WormAction;
import com.neep.neepmeat.entity.worm.WormEntity;
import com.neep.neepmeat.util.Easing;
import java.util.EnumSet;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class WormFullSwingGoal
extends AnimatedWormGoal<WormFullSwingGoal> {
    public static final class_2960 ID = new class_2960("neepmeat", "full_swing");
    protected final WormEntity parent;
    protected float angle;
    protected float finalAngle;
    protected float radius;
    protected final WormAction.Sequence<WormFullSwingGoal> orient = (action, counter) -> {
        if (counter > 20) {
            action.setSequence(action.swing);
            return;
        }
        if (action.parent.getTarget() == null) {
            action.setSequence(action.neutral);
        }
        action.parent.lerpHeadPos(counter, 20, this.getHeadPos(this.angle));
        action.parent.lerpHeadAngles(counter, 20, 0.0f, this.angle);
    };
    protected final WormAction.Sequence<WormFullSwingGoal> swing = (action, counter) -> {
        if (counter > 20) {
            action.setSequence(action.reset);
            return;
        }
        if (action.parent.getTarget() == null) {
            action.setSequence(action.neutral);
        }
        action.angle = (float)(-360.0 * Easing.easeOutBack((float)counter / 20.0f));
        this.apply(action.angle);
    };
    protected final WormAction.Sequence<WormFullSwingGoal> reset = (action, counter) -> {
        this.apply(action.angle + 360.0f);
        action.setSequence(action.neutral);
    };
    protected final WormAction.Sequence<WormFullSwingGoal> neutral = (action, counter) -> {
        if (counter > 20) {
            action.markFinished();
            return;
        }
        action.parent.returnHeadToNeutral(counter, 20);
    };

    public WormFullSwingGoal(WormEntity entity, float radius) {
        this.parent = entity;
        this.angle = entity.method_36454();
        this.finalAngle = this.angle - 360.0f;
        this.radius = radius;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        return this.parent.getTarget() != null && this.parent.method_6051().method_43056();
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.setSequence(this.orient);
    }

    protected class_243 getHeadPos(float angle) {
        return new class_243(this.parent.method_23317() + (double)this.radius * Math.sin(Math.toRadians(angle)), this.parent.method_23318() + 5.0, this.parent.method_23321() + (double)this.radius * Math.cos(Math.toRadians(angle)));
    }

    protected void apply(float angle) {
        this.parent.setHeadAngles(0.0f, angle);
        class_243 headPos = this.getHeadPos(angle);
        this.parent.setHeadPos(headPos.field_1352, headPos.field_1351, headPos.field_1350);
    }
}

