/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.alloy_kiln;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.Heatable;
import com.neep.neepmeat.machine.alloy_kiln.AlloyKilnBlock;
import com.neep.neepmeat.machine.alloy_kiln.AlloyKilnStorage;
import com.neep.neepmeat.recipe.AlloyKilnRecipe;
import com.neep.neepmeat.screen_handler.AlloyKilnScreenHandler;
import com.neep.neepmeat.util.MiscUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;

public class AlloyKilnBlockEntity
extends SyncableBlockEntity
implements Heatable,
class_3908 {
    private boolean updateRecipe;
    protected int fuelTime;
    protected int burnTime;
    protected int cookTime;
    protected int cookTimeTotal;
    protected AlloyKilnRecipe currentRecipe;
    protected AlloyKilnStorage storage;
    protected float heatMultiplier;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return AlloyKilnBlockEntity.this.burnTime;
                }
                case 1: {
                    return AlloyKilnBlockEntity.this.fuelTime;
                }
                case 2: {
                    return AlloyKilnBlockEntity.this.cookTime;
                }
                case 3: {
                    return AlloyKilnBlockEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    AlloyKilnBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    AlloyKilnBlockEntity.this.fuelTime = value;
                    break;
                }
                case 2: {
                    AlloyKilnBlockEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    AlloyKilnBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };

    public AlloyKilnBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.storage = new AlloyKilnStorage(this);
    }

    public AlloyKilnBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.ALLOY_KILN, pos, state);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, AlloyKilnBlockEntity be) {
        be.tick(world, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        this.tryUpdateComparators();
        if (this.updateRecipe) {
            AlloyKilnRecipe recipe;
            this.currentRecipe = recipe = (AlloyKilnRecipe)MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.ALLOY_SMELTING, this.storage).orElse(null);
            if (this.currentRecipe == null) {
                this.cookTimeTotal = -1;
                this.cookTime = 0;
            }
            this.method_5431();
            this.updateRecipe = false;
        }
        boolean wasBurning = this.isBurning();
        this.burnTime = Math.max(0, this.burnTime - 1);
        if (!this.isBurning()) {
            int time;
            if (this.currentRecipe != null && AlloyKilnBlockEntity.canAcceptRecipeOutput(this.currentRecipe, this.storage.inventory.getItems()) && (time = this.storage.decrementFuel()) > 0) {
                this.fuelTime = time;
                this.burnTime = time;
                this.updateState(world, pos, state);
            } else {
                this.cookTime = Math.max(0, this.cookTime - 1);
                if (wasBurning) {
                    this.updateState(world, pos, state);
                }
            }
        }
        if (this.isBurning()) {
            if (!this.isCooking() && this.currentRecipe != null && AlloyKilnBlockEntity.canAcceptRecipeOutput(this.currentRecipe, this.storage.inventory.getItems())) {
                this.cookTimeTotal = this.currentRecipe.getTime();
            }
            if (this.isCooking()) {
                int tickIncrement = Heatable.getFurnaceTickIncrement(this.heatMultiplier);
                this.cookTime = Math.min(this.cookTimeTotal, this.cookTime + tickIncrement);
            }
        }
        if (this.cookTime == this.cookTimeTotal) {
            this.finishCooking();
        }
    }

    public static boolean canAcceptRecipeOutput(@Nullable AlloyKilnRecipe recipe, class_2371<class_1799> slots) {
        if (((class_1799)slots.get(AlloyKilnStorage.INPUT_1)).method_7960() || ((class_1799)slots.get(AlloyKilnStorage.INPUT_2)).method_7960() || recipe == null) {
            return false;
        }
        RecipeOutput<class_1792> output = recipe.getItemOutput();
        class_1799 outputStack = (class_1799)slots.get(AlloyKilnStorage.OUTPUT);
        if (outputStack.method_7960()) {
            return true;
        }
        if (!outputStack.method_31574(output.resource())) {
            return false;
        }
        if (outputStack.method_7947() < outputStack.method_7914()) {
            return true;
        }
        return (long)outputStack.method_7947() < output.maxAmount();
    }

    protected void finishCooking() {
        if (this.currentRecipe != null) {
            try (Transaction transaction = Transaction.openOuter();){
                if (this.currentRecipe.takeInputs(this.storage, (TransactionContext)transaction) && this.currentRecipe.ejectOutput(this.storage, (TransactionContext)transaction)) {
                    transaction.commit();
                } else {
                    transaction.abort();
                }
            }
            this.sync();
        }
        this.currentRecipe = null;
        this.cookTimeTotal = -1;
        this.cookTime = 0;
    }

    protected boolean isCooking() {
        return this.cookTimeTotal != -1;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void setBurning() {
        this.burnTime = 2;
    }

    @Override
    public void updateState(class_1937 world, class_2338 pos, class_2680 oldState) {
        class_2680 state = this.method_11010();
        if (((Boolean)state.method_11654((class_2769)AlloyKilnBlock.LIT)).booleanValue() != this.isBurning()) {
            state = (class_2680)state.method_11657((class_2769)AlloyKilnBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning()));
            this.method_10997().method_8652(pos, state, 3);
        }
    }

    @Override
    public void setHeat(float heat) {
        this.heatMultiplier = heat;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.neepmeat.alloy_kiln");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new AlloyKilnScreenHandler(syncId, inv, this.storage.inventory, this.propertyDelegate);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10575("fuelTime", (short)this.fuelTime);
        nbt.method_10575("burnTime", (short)this.burnTime);
        nbt.method_10575("cookTime", (short)this.cookTime);
        nbt.method_10575("cookTimeTotal", (short)this.cookTimeTotal);
        this.storage.writeNbt(nbt);
        if (this.currentRecipe != null) {
            nbt.method_10582("current_recipe", this.currentRecipe.method_8114().toString());
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.fuelTime = nbt.method_10568("fuelTime");
        this.burnTime = nbt.method_10568("burnTime");
        this.cookTime = nbt.method_10568("cookTime");
        this.cookTimeTotal = nbt.method_10568("cookTimeTotal");
        this.storage.readNbt(nbt);
        this.currentRecipe = MiscUtil.ifPresentOrNull(nbt, "current_recipe", s -> MeatlibRecipes.getInstance().get(class_2960.method_12829((String)s)).orElse(null));
    }

    public AlloyKilnStorage getStorage() {
        return this.storage;
    }

    public void updateRecipe() {
        this.updateRecipe = true;
    }

    @Override
    public void method_5431() {
        super.method_5431();
    }
}

