/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.entity.skyworm.SkywormAnimationTimes;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.block.entity.DistributorPoint;
import com.neep.neepmeat.machine.live_machine.block.entity.DistributorPointBlockEntity;
import com.neep.neepmeat.transport.worm.DistributorDestination;
import com.neep.neepmeat.transport.worm.DistributorParcel;
import com.neep.neepmeat.transport.worm.GlobalDistributorRouting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class DistributorPointProcess
implements Process {
    public static final List<ComponentType<?>> REQUIRED = List.of(LivingMachineComponents.DISTRIBUTOR_POINT);

    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.DISTRIBUTOR_POINT).ifPresent(r -> {
            Collection distributors = r.t1();
            DistributorPointBlockEntity point = (DistributorPointBlockEntity)distributors.iterator().next();
            if (point.getMode().canReceive()) {
                this.handleReceive(point, be.getCombinedItemOutput(), be.getCombinedFluidOutput());
            }
            if (point.getMode().canSend()) {
                this.handleSend(point, be.getCombinedItemInput(), be.getCombinedFluidInput());
            }
        });
    }

    private void handleReceive(DistributorPoint point, Storage<ItemVariant> itemOutput, Storage<FluidVariant> combinedFluidOutput) {
        List<DistributorParcel> queue = point.getQueuedParcels();
        class_2338 dumpPos = point.getDumpPos();
        while (!queue.isEmpty()) {
            DistributorParcel parcel = queue.remove(queue.size() - 1);
            if (parcel.items().isEmpty()) continue;
            Transaction transaction = Transaction.openOuter();
            try {
                for (ResourceAmount<ItemVariant> resourceAmount : parcel.items()) {
                    long transferred = itemOutput.insert((Object)((ItemVariant)resourceAmount.resource()), resourceAmount.amount(), (TransactionContext)transaction);
                    if (transferred >= resourceAmount.amount()) continue;
                    MeatlibStorageUtil.scatterAmount(point.getPointWorld(), dumpPos, (ResourceAmount<ItemVariant>)new ResourceAmount((Object)((ItemVariant)resourceAmount.resource()), resourceAmount.amount() - transferred));
                }
                for (ResourceAmount<ItemVariant> resourceAmount : parcel.fluids()) {
                    long l = combinedFluidOutput.insert((Object)((FluidVariant)resourceAmount.resource()), resourceAmount.amount(), (TransactionContext)transaction);
                }
                transaction.commit();
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
    }

    private void handleSend(DistributorPointBlockEntity point, Storage<ItemVariant> itemInput, Storage<FluidVariant> combinedFluidInput) {
        SkywormAnimationTimes times = new SkywormAnimationTimes(80, 20, 70, 10);
        if (point.timeUntilPickup > 0) {
            --point.timeUntilPickup;
        } else {
            if (point.timeUntilPickup == 0 && point.routeLock != null) {
                try (Transaction transaction = Transaction.openOuter();){
                    DistributorParcel parcel = DistributorPointProcess.extractParcel(itemInput, combinedFluidInput, (TransactionContext)transaction);
                    if (!parcel.isEmpty()) {
                        transaction.commit();
                        GlobalDistributorRouting.getInstance().send(parcel, point.routeLock.asDestination(point.getPointWorld().method_8503()), times);
                    } else {
                        point.routeLock.release(point.getPointWorld().method_8503());
                    }
                    point.timeUntilPickup = point.getMaxCooldown();
                    point.routeLock = null;
                    point.method_5431();
                }
            }
            if (point.timeUntilPickup == 0 && (point.sendNext || point.shouldAutoSend() && point.method_10997().method_8510() % 20L == 0L)) {
                point.sendNext = false;
                GlobalDistributorRouting global = GlobalDistributorRouting.getInstance();
                DistributorDestination dest = global.findAndRoute(new DistributorDestination(point), point.getAddress());
                if (dest != null) {
                    try (Transaction transaction = Transaction.openOuter();){
                        DistributorParcel parcel = DistributorPointProcess.extractParcel(itemInput, combinedFluidInput, (TransactionContext)transaction);
                        if (!parcel.isEmpty()) {
                            point.scheduleSend(global.acquireRoute(dest), times);
                        }
                    }
                }
            }
        }
    }

    private static DistributorParcel extractParcel(Storage<ItemVariant> itemStorage, Storage<FluidVariant> fluidStorage, TransactionContext transaction) {
        List<ResourceAmount<ItemVariant>> items = DistributorPointProcess.extractAvailable(itemStorage, 9, 64L, transaction);
        List<ResourceAmount<FluidVariant>> fluids = DistributorPointProcess.extractAvailable(fluidStorage, 9, 648000L, transaction);
        return new DistributorParcel(items, fluids);
    }

    private static <T> List<ResourceAmount<T>> extractAvailable(Storage<T> storage, int stacks, long max, TransactionContext transaction) {
        ObjectArrayList result = new ObjectArrayList();
        for (int i = 0; i < stacks; ++i) {
            try (Transaction inner = transaction.openNested();){
                Object variant = StorageUtil.findExtractableResource(storage, (TransactionContext)inner);
                if (variant == null) continue;
                long extracted = storage.extract(variant, max, (TransactionContext)inner);
                result.add(new ResourceAmount(variant, extracted));
                inner.commit();
                continue;
            }
        }
        return result;
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return REQUIRED;
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "distributor_point");
    }
}

