/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.neepasm.compiler;

import com.neep.neepmeat.api.plc.instruction.InstructionBuilder;
import com.neep.neepmeat.api.plc.instruction.InstructionException;
import com.neep.neepmeat.api.plc.instruction.SimpleInstructionProvider;
import com.neep.neepmeat.api.plc.program.MutableProgram;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.LabelLookup;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.neepasm.program.KeyValue;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_3218;

public class DefaultParsedInstruction
implements PlcParsedInstruction {
    private final InstructionProvider provider;
    private final List<Argument> arguments;
    private final List<KeyValue> kvs;

    public DefaultParsedInstruction(InstructionProvider provider, List<Argument> arguments, List<KeyValue> kvs) {
        this.provider = provider;
        this.arguments = arguments;
        this.kvs = kvs;
    }

    @Override
    public void build(class_3218 world, LabelLookup labelLookup, MutableProgram program) throws NeepASM.CompilationException {
        if (!(this.provider instanceof SimpleInstructionProvider)) {
            throw new NeepASM.CompilationException("default parser does not support arbitrary arguments");
        }
        try {
            AtomicReference instruction = new AtomicReference();
            InstructionBuilder builder = ((SimpleInstructionProvider)this.provider).start(world, instruction::set);
            for (Argument argument : this.arguments) {
                builder = builder.argument(argument);
            }
            for (KeyValue kv : this.kvs) {
                builder = builder.keyValue(kv);
            }
            if (instruction.get() == null) {
                throw new NeepASM.CompilationException("Insufficient arguments or key-values provided");
            }
            program.addBack((Instruction)instruction.get());
        }
        catch (InstructionException e) {
            throw new NeepASM.CompilationException(e.getMessage());
        }
    }
}

