/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.neepasm.compiler.parser;

import com.google.common.collect.Lists;
import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.meatlib.util.StringTokenView;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.InstructionAcceptor;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.ParsedSource;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.program.Label;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ParsedMacro {
    private final String name;
    private final List<String> parameters;
    private final String macroText;
    private final int startLine;
    private int numExpansions;

    public ParsedMacro(String name, List<String> parameters, String macroText, int startLine) {
        this.name = name;
        this.parameters = parameters;
        this.macroText = macroText;
        this.startLine = startLine;
    }

    public void expand(StringTokenView view, InstructionAcceptor parsedSource, NeepAsmParser parser, Set<ParsedMacro> above) throws NeepASM.ParseException {
        if (above.contains(this)) {
            throw new NeepASM.ParseException("recursive macro expansion: " + this.name);
        }
        above.add(this);
        String localName = this.name + "#" + this.numExpansions;
        ++this.numExpansions;
        view.nextIdentifier();
        ArrayList arguments = Lists.newArrayList();
        for (int i = 0; i < this.parameters.size(); ++i) {
            view.fastForward();
            String arg = ParsedMacro.parseArgumentString(view);
            if (arg.isEmpty()) {
                throw new NeepASM.ParseException("not enough comma-separated macro arguments.");
            }
            if (!view.lineEnded()) {
                view.next();
            }
            arguments.add(arg);
        }
        view.fastForward();
        if (!NeepAsmParser.isComment(view) && !view.lineEnded()) {
            throw new NeepASM.ParseException("too many macro arguments");
        }
        String processed = this.macroText;
        for (int i = 0; i < this.parameters.size(); ++i) {
            processed = processed.replace("%" + this.parameters.get(i), (CharSequence)arguments.get(i));
        }
        NeepAsmTokenView macroView = new NeepAsmTokenView(processed, this.startLine);
        while (!macroView.eof()) {
            this.parseLine(macroView, parsedSource, parser, localName, above);
            macroView.nextLine();
        }
    }

    private void parseLine(NeepAsmTokenView view, InstructionAcceptor parsedSource, NeepAsmParser parser, String localName, Set<ParsedMacro> above) throws NeepASM.ParseException {
        String token;
        try (StringTokenView.Mark entry = view.mark();){
            token = view.nextIdentifier();
            char follow = view.nextThing();
            if (follow == ':') {
                parsedSource.label(new Label(ParsedSource.mangleLabel(token, localName), parsedSource.size()));
                parser.assureLineEnd(view);
                entry.commit();
                return;
            }
        }
        ParsedMacro macro = parsedSource.findMacro(token);
        if (macro != null) {
            macro.expand(view, parsedSource, parser, above);
        } else {
            ParsedInstruction instruction = parser.parseInstruction(view, localName);
            if (instruction != null) {
                parsedSource.instruction(instruction, view.line());
            }
        }
    }

    public static String parseArgumentString(StringTokenView view) {
        view.fastForward();
        StringBuilder builder = new StringBuilder();
        while (!(view.peek() == ',' || view.lineEnded() || NeepAsmParser.isComment(view) || view.eof() || view.lineEnded())) {
            builder.append(view.next());
        }
        return builder.toString().strip();
    }

    public String name() {
        return this.name;
    }
}

