/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.inventory.ImplementedInventory;
import com.neep.neepbus.input.InputInterceptors;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.entity.goal.Action;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.plc.block.entity.ImplanterActuator;
import com.neep.neepmeat.plc.block.entity.ImplanterInputInterceptor;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.plc.instruction.ImplantInstruction;
import com.neep.neepmeat.plc.recipe.ImplantStep;
import com.neep.neepmeat.plc.robot.PLCActuator;
import com.neep.neepmeat.screen_handler.ImplanterScreenHandler;
import com.neep.neepmeat.util.NMMaths;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_5575;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplanterBlockEntity
extends SyncableBlockEntity
implements PLCActuator,
PLCActuator.Provider,
ImplanterActuator {
    public static final class_2960 ID = new class_2960("neepmeat", "implanter_movement");
    private final ImplementedInventory inventory = new ImplementedInventory(){
        private final class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);

        @Override
        public class_2371<class_1799> getItems() {
            return this.items;
        }

        public int method_5444() {
            return 1;
        }

        @Override
        public void method_5431() {
            ImplanterBlockEntity.this.method_5431();
        }
    };
    private final ImplanterInputInterceptor interceptor = new ImplanterInputInterceptor();
    private final ImplantAction action = new ImplantAction();
    public float renderYaw;
    public float renderX;
    public float renderY;
    public float cameraYaw;
    public float cameraX;
    public float cameraY;
    private float yaw = 0.0f;
    private float x = 1.0f;
    private float y = 1.0f;
    @Nullable
    private class_243 targetEndPos;

    public ImplanterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void sync() {
        super.sync();
    }

    @Override
    public void method_5431() {
        super.method_5431();
    }

    public void serverTick() {
        if (this.interceptor.controller != null) {
            float speed = 0.08f;
            float vYaw = 0.0f;
            float vx = 0.0f;
            float vy = 0.0f;
            if (this.interceptor.forward) {
                vx += 1.0f;
            }
            if (this.interceptor.back) {
                vx -= 1.0f;
            }
            if (this.interceptor.left) {
                vYaw += 1.0f;
            }
            if (this.interceptor.right) {
                vYaw -= 1.0f;
            }
            if (this.interceptor.up) {
                vy += 1.0f;
            }
            if (this.interceptor.down) {
                vy -= 1.0f;
            }
            this.yaw += vYaw * 0.2f * speed;
            this.x += vx * speed;
            this.y += vy * speed;
            this.limitPosition();
            this.softSync();
        } else if (this.targetEndPos != null) {
            float speed = 0.08f;
            this.moveAuto(NMMaths.wrapRadians((float)this.targetEndPos.field_1352), (float)this.targetEndPos.field_1351, (float)this.targetEndPos.field_1350, speed * 3.0f);
            this.sync();
        }
        this.action.method_6268();
    }

    private void moveAuto(float tYaw, float tx, float ty, float speed) {
        this.yaw = NMMaths.moveTowardsAngle(this.yaw, tYaw, speed * 0.4f);
        if (this.yaw != tYaw) {
            this.x = NMMaths.moveTowards(this.x, 1.0f, speed);
            this.y = NMMaths.moveTowards(this.y, 1.0f, speed);
        } else {
            this.x = NMMaths.moveTowards(this.x, tx, speed);
            this.y = NMMaths.moveTowards(this.y, ty, speed);
        }
        if (this.reachedTarget(null)) {
            this.targetEndPos = null;
        }
    }

    public void clientTick() {
    }

    private void limitPosition() {
        float magnitude = class_3532.method_15355((float)(this.x * this.x + this.y * this.y));
        this.x = this.x / magnitude * Math.min(magnitude, 4.6f);
        this.y = this.y / magnitude * Math.min(magnitude, 4.6f);
        this.y = Math.max(this.y, -2.0f);
        this.x = Math.max(this.x, 1.0f);
    }

    private boolean inBounds(float tx, float ty) {
        float magnitude = class_3532.method_15355((float)(tx * tx + ty * ty));
        return magnitude <= 4.6f && this.y >= -2.0f && tx >= 1.0f;
    }

    @Override
    public void targetRestPos() {
        this.targetEndPos = new class_243((double)this.yaw, 1.0, 1.0);
    }

    public void onUse(class_1657 user, class_1268 hand) {
        if (this.interceptor.controller == null) {
            user.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
                    packetByteBuf.method_10807(ImplanterBlockEntity.this.field_11867);
                }

                public class_2561 method_5476() {
                    return class_2561.method_43473();
                }

                @NotNull
                public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                    return new ImplanterScreenHandler(playerInventory, ImplanterBlockEntity.this.inventory, syncId, ImplanterBlockEntity.this);
                }
            });
            InputInterceptors.activate(user, this.interceptor);
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("arm_x", this.x);
        nbt.method_10548("arm_y", this.y);
        nbt.method_10548("yaw", this.yaw);
        this.inventory.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.x = nbt.method_10583("arm_x");
        this.y = nbt.method_10583("arm_y");
        this.yaw = nbt.method_10583("yaw");
        this.inventory.readNbt(nbt);
    }

    public float getYaw() {
        return this.yaw;
    }

    @Override
    public class_2338 getBasePos() {
        return this.field_11867;
    }

    @Override
    public void spawnItem(@Nullable ResourceAmount<ItemVariant> stored) {
        if (stored == null) {
            return;
        }
        class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 1.25), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)((ItemVariant)stored.resource()).toStack((int)stored.amount()));
    }

    public float getPolX() {
        return this.x;
    }

    public float getPolY() {
        return this.y;
    }

    @Override
    public boolean actuatorRemoved() {
        return false;
    }

    public class_243 endOrigin() {
        double c = class_3532.method_15362((float)this.yaw);
        double s = class_3532.method_15374((float)this.yaw);
        double x1 = (double)this.field_11867.method_10263() + 0.5 + (double)this.x * s;
        double z1 = (double)this.field_11867.method_10260() + 0.5 + (double)this.x * c;
        double y1 = (float)this.field_11867.method_10264() + this.y;
        return new class_243(x1, y1, z1);
    }

    public class_243 direction() {
        double dx = this.x * class_3532.method_15374((float)this.yaw);
        double dz = this.x * class_3532.method_15362((float)this.yaw);
        return new class_243(dx, 0.0, dz).method_1029();
    }

    @Nullable
    public class_1297 raycast() {
        class_243 start = this.endOrigin();
        class_243 direction = this.direction();
        class_243 end = start.method_1019(this.direction());
        class_238 box = class_238.method_30048((class_243)start, (double)0.5, (double)0.5, (double)0.5).method_1012(direction.field_1352, 0.0, direction.field_1350);
        List entities = this.field_11863.method_18023(class_5575.method_31795(class_1297.class), box, e -> true);
        for (class_1297 entity : entities) {
            if (!entity.method_5829().method_992(start, end).isPresent()) continue;
            return entity;
        }
        return null;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    @Override
    public double getX() {
        return (double)this.field_11867.method_10263() + 0.5 + (double)(this.x * class_3532.method_15374((float)this.yaw));
    }

    @Override
    public double getY() {
        return (float)this.field_11867.method_10264() + this.y;
    }

    @Override
    public double getZ() {
        return (double)this.field_11867.method_10260() + 0.5 + (double)(this.x * class_3532.method_15362((float)this.yaw));
    }

    public void startApplySequence() {
        this.action.start();
    }

    @Override
    public void setImplantTarget(PLC plc, class_243 implantSite, class_1297 target) {
        class_243 headToImplanter = new class_243((double)this.field_11867.method_10263() + 0.5, 0.0, (double)this.field_11867.method_10260()).method_1023(implantSite.field_1352, 0.0, implantSite.field_1350).method_1029().method_1021((double)(target.method_17681() / 2.0f) + 0.3);
        this.setTargetPlatform(plc, implantSite.method_1019(headToImplanter));
    }

    private void applyImplant() {
        class_1297 entity = this.raycast();
        class_1799 stack = this.inventory.method_5438(0);
        if (entity != null && !stack.method_7960()) {
            MutateInPlace<class_1297> mip = MutateInPlace.of(entity);
            ImplantStep step = new ImplantStep(stack.method_7909());
            boolean success = ImplantInstruction.install(step, mip);
            if (success) {
                this.inventory.method_5447(0, class_1799.field_8037);
            }
        }
    }

    @Override
    public PLCActuator getPlcActuator() {
        return this;
    }

    @Override
    public void setStored(PLC plc, @Nullable ResourceAmount<ItemVariant> stored) {
        if (stored != null) {
            this.inventory.method_5447(0, new class_1799((class_1935)((ItemVariant)stored.resource()).getItem(), (int)stored.amount()));
        } else {
            this.inventory.method_5447(0, class_1799.field_8037);
        }
    }

    @Override
    @Nullable
    public ResourceAmount<ItemVariant> getStored(PLC plc) {
        return new ResourceAmount((Object)ItemVariant.of((class_1799)this.inventory.method_5438(0)), (long)this.inventory.method_5438(0).method_7947());
    }

    @Override
    public void dumpStored(@Nullable PLC ignored) {
        if (!this.inventory.method_5442()) {
            this.spawnItem((ResourceAmount<ItemVariant>)new ResourceAmount((Object)ItemVariant.of((class_1799)this.inventory.method_5438(0)), (long)this.inventory.method_5438(0).method_7947()));
        }
        this.inventory.method_5441(0);
    }

    public void setTargetPlatform(PLC plc, @Nullable class_243 target) {
        if (target == null) {
            this.targetEndPos = null;
        } else {
            float ty;
            float rx = (float)(target.field_1352 - (double)this.field_11867.method_10263() - 0.5);
            float rz = (float)(target.field_1350 - (double)this.field_11867.method_10260() - 0.5);
            float tYaw = (float)Math.atan2(rx, rz);
            float tx = class_3532.method_15355((float)(rx * rx + rz * rz));
            if (!this.inBounds(tx, ty = (float)(target.field_1351 - (double)this.field_11867.method_10264()))) {
                plc.raiseError(new PLC.Error("implanter: position out of reach"));
                return;
            }
            this.targetEndPos = new class_243((double)tYaw, (double)tx, (double)ty);
        }
    }

    @Override
    public void setTarget(PLC plc, @Nullable class_2338 target) {
        this.setTargetPlatform(plc, target != null ? class_243.method_26410((class_2382)target, (double)0.0) : null);
    }

    @Override
    public boolean reachedTarget(@Nullable PLC unused) {
        if (this.targetEndPos == null) {
            return true;
        }
        return (double)this.yaw == this.targetEndPos.field_1352 && (double)this.x == this.targetEndPos.field_1351 && (double)this.y == this.targetEndPos.field_1350;
    }

    public void setYaw(float rotation) {
        this.yaw = (float)Math.PI / 180 * rotation;
    }

    private class ImplantAction
    extends Action.Simple<ImplantAction> {
        private final Action.Sequence<ImplantAction> playSound = (parent, counter) -> {
            ImplanterBlockEntity.this.field_11863.method_8396(null, ImplanterBlockEntity.this.field_11867, NMSounds.IMPLANT_INSTRUCTION_APPLY, class_3419.field_15254, 1.0f, 1.0f);
            this.setSequence(this.wait);
        };
        private final Action.Sequence<ImplantAction> wait = (parent, counter) -> {
            if (counter > 40) {
                this.setSequence(this.implant);
            }
        };
        private final Action.Sequence<ImplantAction> implant = (parent, counter) -> {
            ImplanterBlockEntity.this.applyImplant();
            this.setSequence(null);
        };

        private ImplantAction() {
        }

        public void start() {
            this.setSequence(this.playSound);
        }
    }
}

