/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.editor;

import com.neep.neepmeat.api.plc.instruction.InstructionBuilder;
import com.neep.neepmeat.api.plc.instruction.InstructionException;
import com.neep.neepmeat.api.plc.instruction.SimpleInstructionProvider;
import com.neep.neepmeat.client.screen.plc.RecordMode;
import com.neep.neepmeat.network.plc.PLCErrorMessageS2C;
import com.neep.neepmeat.plc.PLCState;
import com.neep.neepmeat.plc.block.entity.PLCBlockEntity;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class ShellState
implements PLCState {
    private final PLCBlockEntity parent;
    @Nullable
    private InstructionBuilder instructionBuilder;
    @Nullable
    private InstructionProvider provider;

    public ShellState(PLCBlockEntity plc) {
        this.parent = plc;
    }

    @Override
    public void setInstructionBuilder(InstructionProvider provider) {
        if (provider instanceof SimpleInstructionProvider) {
            SimpleInstructionProvider provider1 = (SimpleInstructionProvider)provider;
            this.instructionBuilder = provider1.start((class_3218)this.parent.method_10997(), this::emitInstruction);
        }
        this.provider = provider;
    }

    private void emitInstruction(Instruction instruction) {
        this.parent.resetError();
        this.parent.stop();
        if (this.parent.notExecuting()) {
            this.parent.setCounter(0);
            this.parent.execute(instruction);
        }
    }

    @Override
    public void argument(Argument argument) {
        if (this.instructionBuilder != null) {
            try {
                this.instructionBuilder.argument(argument);
            }
            catch (InstructionException e) {
                PLCErrorMessageS2C.send((class_3222)this.parent.getSurgeryRobot().getController(), e.getMessage());
            }
        }
    }

    @Override
    public RecordMode getMode() {
        return RecordMode.IMMEDIATE;
    }

    @Override
    public int getArgumentCount() {
        if (this.instructionBuilder == null) {
            return 0;
        }
        return this.instructionBuilder.argumentCount();
    }

    @Override
    public int getMaxArguments() {
        InstructionProvider instructionProvider = this.provider;
        if (instructionProvider instanceof SimpleInstructionProvider) {
            SimpleInstructionProvider simpleInstructionProvider = (SimpleInstructionProvider)instructionProvider;
            return simpleInstructionProvider.maxArguments();
        }
        return 0;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
    }
}

