/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.recipe.Workpiece;
import com.neep.neepmeat.api.plc.robot.AtomicAction;
import com.neep.neepmeat.api.plc.robot.DelayAction;
import com.neep.neepmeat.api.plc.robot.GroupedRobotAction;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.recipe.EntityMutateRecipe;
import com.neep.neepmeat.plc.recipe.InjectStep;
import com.neep.neepmeat.plc.recipe.ItemManufactureRecipe;
import com.neep.neepmeat.plc.recipe.PLCRecipes;
import com.neep.neepmeat.plc.recipe.TransformingToolRecipe;
import com.neep.neepmeat.plc.robot.PLCActuator;
import com.neep.neepmeat.plc.robot.RobotMoveToAction;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public class InjectInstruction
implements PlcInstruction {
    private final Supplier<class_1937> world;
    private final Argument from;
    private final Argument to;
    private ResourceAmount<FluidVariant> stored;
    private final GroupedRobotAction group;

    public InjectInstruction(Supplier<class_1937> world, List<Argument> arguments) {
        this.world = world;
        this.from = arguments.get(0);
        this.to = arguments.get(1);
        this.group = GroupedRobotAction.of(new RobotMoveToAction(this.from.pos()), AtomicAction.of(this::playTakeSound), AtomicAction.of(this::takeFrom), new Glue(this.to.pos()), AtomicAction.of(this::playSound), new DelayAction(40), AtomicAction.of(this::insert));
    }

    private void playTakeSound(PLC plc) {
        PLCActuator robot = plc.getActuator();
        this.world.get().method_47967(null, robot.getX(), robot.getY(), robot.getZ(), class_3417.field_14978, class_3419.field_15245, 1.0f, 1.0f, 1L);
    }

    private void playSound(PLC plc) {
        PLCActuator robot = plc.getActuator();
        this.world.get().method_47967(null, robot.getX(), robot.getY(), robot.getZ(), NMSounds.INJECT_INSTRUCTION_APPLY, class_3419.field_15245, 1.0f, 1.0f, 1L);
    }

    public InjectInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this(world, List.of(Argument.fromNbt(nbt.method_10562("from")), Argument.fromNbt(nbt.method_10562("to"))));
        this.group.readNbt(nbt.method_10562("action"));
        this.stored = PlcInstruction.readFluid(nbt.method_10562("stored"));
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("from", (class_2520)this.from.toNbt());
        nbt.method_10566("to", (class_2520)this.to.toNbt());
        nbt.method_10566("action", (class_2520)this.group.writeNbt(new class_2487()));
        nbt.method_10566("stored", (class_2520)PlcInstruction.writeFluid(this.stored));
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        plc.addRobotAction(this.group, this::finish);
    }

    @Override
    public void cancel(PLC plc) {
        this.group.end(plc);
    }

    private void takeFrom(PLC plc) {
        ResourceAmount<FluidVariant> takenAmount = Instructions.takeFluid(this.from, this.world, 81000L);
        if (takenAmount != null) {
            this.stored = takenAmount;
        } else {
            plc.raiseError(new PLC.Error("Insufficient or no fluid at " + String.valueOf(this.from)));
        }
    }

    private boolean insertToItem(MutateInPlace<class_1799> mip, InjectStep step) {
        Workpiece workpiece;
        class_1799 stack = mip.get();
        if (stack != null && (workpiece = (Workpiece)NMComponents.WORKPIECE.getNullable((Object)stack)) != null && PLCRecipes.isValidStep(PLCRecipes.MANUFACTURE, workpiece, step, stack.method_7909())) {
            workpiece.addStep(step);
            mip.setResult(1, stack);
            ItemManufactureRecipe recipe = MeatlibRecipes.getInstance().getFirstMatch(PLCRecipes.MANUFACTURE, mip).orElse(null);
            if (recipe != null) {
                recipe.ejectOutputs(mip, (TransactionContext)null);
                workpiece.clearSteps();
            } else {
                TransformingToolRecipe transformingToolRecipe = TransformingToolRecipe.getInstance();
                if (transformingToolRecipe.matches(mip)) {
                    transformingToolRecipe.ejectOutputs(mip, (TransactionContext)null);
                    workpiece.clearSteps();
                }
            }
            return true;
        }
        return false;
    }

    private void returnFluid() {
        if (this.stored != null) {
            Instructions.giveFluid(this.from, this.world, this.stored);
            this.stored = null;
        }
    }

    private boolean insertToEntity(MutateInPlace<class_1297> mip, InjectStep step) {
        Workpiece workpiece;
        class_1297 entity = mip.get();
        if (entity != null && (workpiece = (Workpiece)NMComponents.WORKPIECE.getNullable((Object)entity)) != null) {
            workpiece.addStep(step);
            mip.setResult(1, entity);
            EntityMutateRecipe recipe = PLCRecipes.matchEntityMutate(mip);
            if (recipe != null) {
                recipe.ejectOutputs(mip, null);
                workpiece.clearSteps();
            }
            return true;
        }
        return false;
    }

    private void insert(PLC plc) {
        if (this.stored != null) {
            InjectStep step = new InjectStep((FluidVariant)this.stored.resource());
            MutateInPlace itemMip = (MutateInPlace)MutateInPlace.ITEM.find(this.world.get(), this.to.pos(), null);
            if (itemMip != null) {
                if (this.insertToItem(itemMip, step)) {
                    this.stored = null;
                }
                return;
            }
            MutateInPlace entityMip = (MutateInPlace)MutateInPlace.ENTITY.find(this.world.get(), this.to.pos(), null);
            if (entityMip != null) {
                if (this.insertToEntity(entityMip, step)) {
                    this.stored = null;
                }
                return;
            }
        }
    }

    private void finish(PLC plc) {
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.INJECT;
    }

    private class Glue
    extends RobotMoveToAction {
        public Glue(class_2338 target) {
            super(target);
        }

        @Override
        public void start(PLC plc) {
            super.start(plc);
            MutateInPlace itemMip = (MutateInPlace)MutateInPlace.ITEM.find(InjectInstruction.this.world.get(), InjectInstruction.this.to.pos(), null);
            if (itemMip != null) {
                return;
            }
            MutateInPlace entityMip = (MutateInPlace)MutateInPlace.ENTITY.find(InjectInstruction.this.world.get(), InjectInstruction.this.to.pos(), null);
            if (entityMip != null && entityMip.get() != null) {
                return;
            }
            plc.raiseError(new PLC.Error("inject: No item or entity"));
            InjectInstruction.this.returnFluid();
        }
    }
}

