/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.google.gson.JsonObject;
import com.neep.meatlib.recipe.ImplementedRecipe;
import com.neep.meatlib.recipe.ingredient.Ingredients;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.neepmeat.api.processing.OreFatRegistry;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.crucible.CrucibleStorage;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class OreFatRenderingRecipe
extends ImplementedRecipe<CrucibleStorage> {
    protected class_2960 id;
    protected RegistryRecipeInput<class_3611> fluidInput;
    protected RecipeOutput<class_3611> fluidOutput;

    public OreFatRenderingRecipe(class_2960 id, RegistryRecipeInput<class_3611> fluidInput, RecipeOutput<class_3611> fluidOutput) {
        this.fluidInput = fluidInput;
        this.fluidOutput = fluidOutput;
        this.id = id;
    }

    public boolean matches(CrucibleStorage inventory, class_1937 world) {
        return this.fluidInput.test((StorageView<TransferVariant<?>>)inventory.getStorage(null)) && OreFatRegistry.getFromInput(((ItemVariant)inventory.getItemStorage(null).getResource()).getItem()) != null;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return false;
    }

    public RegistryRecipeInput<class_3611> getFluidInput() {
        return this.fluidInput;
    }

    public RecipeOutput<class_3611> getFluidOutput() {
        return this.fluidOutput;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return NMrecipeTypes.ORE_FAT_RENDERING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.ORE_FAT_RENDERING;
    }

    public class_1792 takeInputs(CrucibleStorage storage, int itemAmount, TransactionContext transaction) {
        class_1792 item;
        OreFatRegistry.Entry entry;
        block18: {
            SingleSlotStorage<ItemVariant> itemStorage = storage.getItemStorage(null);
            SingleSlotStorage<FluidVariant> fluidStorage = storage.getStorage(null);
            entry = OreFatRegistry.getFromInput(((ItemVariant)itemStorage.getResource()).getItem());
            item = ((ItemVariant)itemStorage.getResource()).getItem();
            try (Transaction take = transaction.openNested();){
                Optional<class_3611> fluid = this.fluidInput.getFirstMatching((Storage<TransferVariant<?>>)fluidStorage, (TransactionContext)take);
                if (entry == null || fluid.isEmpty()) {
                    class_1792 class_17922 = null;
                    return class_17922;
                }
                long ex1 = itemStorage.extract((Object)ItemVariant.of((class_1935)item), (long)itemAmount, (TransactionContext)take);
                long ex2 = fluidStorage.extract((Object)FluidVariant.of((class_3611)fluid.get()), this.fluidInput.amount() * (long)itemAmount, (TransactionContext)take);
                if (ex1 == (long)itemAmount && ex2 == this.fluidInput.amount() * (long)itemAmount) {
                    take.commit();
                    break block18;
                }
                take.abort();
                class_1792 class_17923 = null;
                return class_17923;
            }
        }
        try (Transaction eject = transaction.openNested();){
            boolean bl1 = true;
            this.fluidOutput.setNbt(entry.nbt());
            FluidVariant outputVariant = FluidVariant.of((class_3611)this.fluidOutput.resource(), (class_2487)entry.nbt());
            for (int i = 0; i < itemAmount; ++i) {
                bl1 = bl1 && storage.getFluidOutput().insert((Object)outputVariant, 9000L * this.fluidOutput.randomAmount(entry.renderingYield() - 1.0f), (TransactionContext)eject) > 0L;
            }
            this.fluidOutput.setNbt(null);
            if (bl1) {
                eject.commit();
                class_1792 class_17924 = item;
                return class_17924;
            }
            eject.abort();
        }
        return null;
    }

    public static class Serializer
    implements class_1865<OreFatRenderingRecipe> {
        RecipeFactory<OreFatRenderingRecipe> factory;

        public Serializer(RecipeFactory<OreFatRenderingRecipe> recipeFactory) {
            this.factory = recipeFactory;
        }

        public OreFatRenderingRecipe read(class_2960 id, JsonObject json) {
            JsonObject fluidInputElement = class_3518.method_15296((JsonObject)json, (String)"fluid_input");
            RegistryRecipeInput<class_3611> fluidInput = RegistryRecipeInput.fromJson(RecipeInputs.FLUID, fluidInputElement);
            JsonObject outputElement = class_3518.method_15296((JsonObject)json, (String)"output");
            RecipeOutput<class_3611> fluidOutput = RecipeOutputImpl.fromJson(Ingredients.FLUID, outputElement);
            return this.factory.create(id, fluidInput, fluidOutput);
        }

        public OreFatRenderingRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_3611> fluidInput = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_3611> fluidOutput = RecipeOutputImpl.read(class_7923.field_41173, buf);
            return this.factory.create(id, fluidInput, fluidOutput);
        }

        public void write(class_2540 buf, OreFatRenderingRecipe recipe) {
            recipe.fluidInput.write(buf);
            recipe.fluidOutput.write(buf);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends OreFatRenderingRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_3611> var2, RecipeOutput<class_3611> var3);
        }
    }
}

