/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.fluid_network;

import com.neep.neepmeat.transport.fluid_network.FluidNodeManager;
import com.neep.neepmeat.transport.fluid_network.node.FluidNode;
import com.neep.neepmeat.transport.fluid_network.node.NodePos;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.Nullable;

public class FluidNodeManagerImpl
implements FluidNodeManager {
    protected static final HashMap<class_3218, FluidNodeManager> WORLD_MANAGERS = new HashMap();
    protected final Long2ObjectMap<Map<NodePos, FluidNode>> chunkNodes = new Long2ObjectArrayMap();
    protected final class_3218 world;

    public FluidNodeManagerImpl(class_3218 world) {
        this.world = world;
    }

    public static FluidNodeManager getInstance(class_3218 world) {
        return WORLD_MANAGERS.computeIfAbsent(world, FluidNodeManagerImpl::create);
    }

    protected static FluidNodeManager create(class_3218 world) {
        return new FluidNodeManagerImpl(world);
    }

    private static void startWorld(MinecraftServer server, class_3218 world) {
        FluidNodeManagerImpl.create(world);
    }

    private static void stopWorld(MinecraftServer server, class_3218 world) {
        WORLD_MANAGERS.clear();
    }

    public static void removeStorageNodes(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            NodePos nodePos = new NodePos(pos, direction);
            FluidNodeManagerImpl.getInstance((class_3218)world).removeNode(nodePos);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.chunkNodes.hashCode()).append((Object)this.world).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FluidNodeManagerImpl)) {
            return false;
        }
        FluidNodeManagerImpl network = (FluidNodeManagerImpl)o;
        return network.world.equals(this.world) && network.chunkNodes.equals(this.chunkNodes);
    }

    public Map<NodePos, FluidNode> getOrCreateMap(class_1923 chunkPos) {
        HashMap<NodePos, FluidNode> out = (HashMap<NodePos, FluidNode>)this.chunkNodes.get(chunkPos.method_8324());
        if (out != null) {
            return out;
        }
        out = new HashMap<NodePos, FluidNode>();
        this.chunkNodes.put(chunkPos.method_8324(), out);
        return out;
    }

    @Override
    public boolean removeNode(NodePos pos) {
        Map nodes = (Map)this.chunkNodes.get(pos.toChunkPos().method_8324());
        if (nodes == null) {
            return false;
        }
        if (nodes.get(pos) != null) {
            ((FluidNode)nodes.get(pos)).onRemove();
            nodes.remove(pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean updatePosition(class_1937 world, NodePos pos) {
        Storage storage = (Storage)FluidStorage.SIDED.find(world, pos.facingBlock(), (Object)pos.face().method_10153());
        if (storage == null) {
            if (this.get(pos) != null) {
                this.removeNode(pos);
                return true;
            }
            return false;
        }
        Map<NodePos, FluidNode> nodes = this.getOrCreateMap(pos.toChunkPos());
        FluidNode prevNode = nodes.get(pos);
        if (prevNode == null) {
            FluidNode node = new FluidNode(pos, (class_3218)world);
            nodes.put(pos, node);
            return true;
        }
        if (prevNode.getStorage((class_3218)world) != storage) {
            prevNode.findStorage((class_3218)world);
            return false;
        }
        return false;
    }

    @Override
    public List<FluidNode> getNodes(class_2338 pos) {
        ArrayList<FluidNode> list = new ArrayList<FluidNode>();
        for (class_2350 direction : class_2350.values()) {
            FluidNode node = this.get(new NodePos(pos, direction));
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    private void putNodes(List<FluidNode> nodes, class_2338 pos) {
        Map<NodePos, FluidNode> map = this.getOrCreateMap(class_4076.method_18682((class_2338)pos).method_18692());
        for (FluidNode node : nodes) {
            map.put(node.getNodePos(), node);
        }
    }

    @Override
    public void entityRemoved(class_2338 pos) {
        this.getNodes(pos).forEach(FluidNode::onRemove);
    }

    @Override
    public void entityUnloaded(class_2338 pos) {
        List<FluidNode> nodes = this.getNodes(pos);
        nodes.forEach(FluidNode::onRemove);
    }

    @Override
    @Nullable
    public FluidNode get(NodePos nodePos) {
        return this.getOrCreateMap(nodePos.toChunkPos()).get(nodePos);
    }

    @Override
    public class_2487 writeNodes(class_2338 pos, class_2487 nbt) {
        for (FluidNode node : this.getNodes(pos)) {
            class_2487 nodeNbt = new class_2487();
            nodeNbt = node.writeNbt(nodeNbt);
            nbt.method_10566(node.getNodePos().face().toString(), (class_2520)nodeNbt);
        }
        return nbt;
    }

    @Override
    public void readNodes(class_2338 pos, class_2487 nbt, class_3218 world) {
        ArrayList<FluidNode> nodes = new ArrayList<FluidNode>();
        for (class_2350 direction : class_2350.values()) {
            class_2520 nodeNbt = nbt.method_10580(direction.toString());
            if (nodeNbt == null) continue;
            nodes.add(FluidNode.fromNbt((class_2487)nodeNbt, world));
        }
        this.putNodes(nodes, pos);
    }

    public static void registerEvents() {
        ServerWorldEvents.LOAD.register(FluidNodeManagerImpl::startWorld);
        ServerWorldEvents.UNLOAD.register(FluidNodeManagerImpl::stopWorld);
    }
}

