/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.screen;

import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.api.network.ParamCodecs;
import com.neep.meatlib.network.ChannelManager;
import com.neep.meatlib.screen.WidgetHandler;
import com.neep.neepmeat.item.filter.Filter;
import com.neep.neepmeat.item.filter.FilterList;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class FilterWidgetHandler
implements WidgetHandler {
    public final ChannelManager<UpdateToClient> updateToClient;
    public final ChannelManager<UpdateToServer> updateToServer;
    public final ChannelManager<AddFilter> addFilter;
    public final ChannelManager<RemoveFilter> removeFilter;
    public final ChannelManager<SetInverted> setInverted;
    private FilterList filter;

    public FilterWidgetHandler(class_1657 player, FilterList filter) {
        this.updateToServer = ChannelManager.create(new class_2960("neepmeat", "update_to_server"), ChannelFormat.builder(UpdateToServer.class).param(ParamCodec.INT).param(ParamCodec.NBT).build(), player);
        this.updateToClient = ChannelManager.create(new class_2960("neepmeat", "update_to_client"), ChannelFormat.builder(UpdateToClient.class).param(FilterList.CODEC).build(), player);
        this.addFilter = ChannelManager.create(new class_2960("neepmeat", "add_filter"), ChannelFormat.builder(AddFilter.class).param(ParamCodecs.IDENTIFIER).build(), player);
        this.removeFilter = ChannelManager.create(new class_2960("neepmeat", "remove_filter"), ChannelFormat.builder(RemoveFilter.class).param(ParamCodec.INT).build(), player);
        this.setInverted = ChannelManager.create(new class_2960("neepmeat", "set_inverted"), ChannelFormat.builder(SetInverted.class).param(ParamCodec.INT).param(ParamCodec.BOOLEAN).build(), player);
        this.filter = filter;
        this.updateToServer.receiver(this::updateToServer);
        this.addFilter.receiver(this::addFilter);
        this.removeFilter.receiver(this::removeFilter);
        this.setInverted.receiver(this::onSetInverted);
    }

    public void updateToServer(int index, class_2487 nbt) {
        if (index >= 0 && index < this.filter.size()) {
            this.filter.getEntries().get(index).update(nbt);
            this.filter.markDirty();
        }
    }

    public FilterList getFilters() {
        return this.filter;
    }

    private void removeFilter(int index) {
        if (index >= 0 && index < this.filter.size()) {
            this.filter.remove(index);
            this.filter.markDirty();
        }
    }

    public void addFilter(Filter.Constructor<?> filter) {
        class_2960 id = Filter.REGISTRY.method_10221(filter);
        this.addFilter.emitter().apply(id);
    }

    private void addFilter(class_2960 id) {
        Filter.Constructor constructor = (Filter.Constructor)Filter.REGISTRY.method_10223(id);
        if (constructor != null) {
            Object filter = constructor.create();
            this.filter.add((Filter)filter);
            this.filter.markDirty();
        }
    }

    public void setInverted(int index, boolean inverted) {
        this.setInverted.emitter().apply(index, inverted);
    }

    private void onSetInverted(int index, boolean inverted) {
        this.filter.getEntries().get(index).setInverted(inverted);
    }

    @Override
    public void sendUpdates() {
        this.updateToClient.emitter().apply(this.filter);
    }

    public void updateOnClient(FilterList filter) {
        this.filter = filter;
    }

    @Override
    public void close() {
        this.updateToClient.close();
        this.updateToServer.close();
        this.addFilter.close();
        this.removeFilter.close();
        this.setInverted.close();
    }

    public static interface UpdateToServer {
        public void apply(int var1, class_2487 var2);
    }

    public static interface UpdateToClient {
        public void apply(FilterList var1);
    }

    public static interface AddFilter {
        public void apply(class_2960 var1);
    }

    public static interface RemoveFilter {
        public void apply(int var1);
    }

    public static interface SetInverted {
        public void apply(int var1, boolean var2);
    }
}

