/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib;

import com.mojang.serialization.Lifecycle;
import com.neep.meatlib.MeatLibRegistration;
import com.neep.meatlib.api.event.DataPackPostProcess;
import com.neep.meatlib.api.event.InitialTicks;
import com.neep.meatlib.graphics.GraphicsEffects;
import com.neep.meatlib.item.MeatItemGroups;
import com.neep.meatlib.item.ScrollableItems;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.registry.SoundRegistry;
import com.neep.meatlib.screen.ScreenReady;
import com.neep.meatlib.storage.StorageEvents;
import com.neep.neepbus.NeepBus;
import com.neep.neepmeat.util.MinecraftServerAccess;
import java.util.HashSet;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_2348;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MeatLib
implements ModInitializer {
    public static final String NAMESPACE = "meatlib";
    public static final Logger LOGGER = LogManager.getLogger((String)"meatlib");
    public static String CURRENT_NAMESPACE;
    private static boolean active;
    public static final String FLOAT_REGEX = "[+-]?([0-9]*[.])?[0-9]+";
    public static BlockApiLookup<Void, Void> VOID_LOOKUP;

    public static void assertActive(Object object) {
        if (CURRENT_NAMESPACE == null) {
            throw new IllegalStateException("MeatLib: Object '" + String.valueOf(object) + "' was queued for registration without a namespace");
        }
    }

    public static String formatEngineering(double value, int dp, boolean usePrefix, String unit) {
        if (value == 0.0) {
            return String.format("%." + dp + "f%s", 0.0, unit);
        }
        double log10 = Math.log10(Math.abs(value));
        int threes = (int)Math.floor(log10 / 3.0);
        value /= Math.pow(10.0, threes * 3);
        int idx = threes + 5;
        if (usePrefix && idx > 0 && idx < NeepBus.METRIC_PREFIXES.length) {
            return String.format("%." + dp + "f%s%s", value, NeepBus.METRIC_PREFIXES[idx], unit);
        }
        return String.format("%." + dp + "fE%d%s", value, threes * 3, unit);
    }

    public static <T> FabricRegistryBuilder<T, class_2370<T>> createSimple(class_5321<class_2378<T>> key) {
        return FabricRegistryBuilder.from((class_2385)new class_2370(key, Lifecycle.stable(), null));
    }

    public static <T> FabricRegistryBuilder<T, class_2348<T>> createDefaulted(class_5321<class_2378<T>> key, class_2960 defaultId) {
        return FabricRegistryBuilder.from((class_2385)new class_2348(defaultId.toString(), key, Lifecycle.stable(), null));
    }

    public void onInitialize() {
        MinecraftServerAccess.init();
        SoundRegistry.init();
        GraphicsEffects.init();
        MeatlibRecipes.init();
        InitialTicks.init();
        StorageEvents.init();
        RecipeInputs.init();
        MeatItemGroups.init();
        ScrollableItems.init();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> ((DataPackPostProcess)DataPackPostProcess.AFTER_DATA_PACK_LOAD.invoker()).event(server));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, manager, success) -> ((DataPackPostProcess)DataPackPostProcess.AFTER_DATA_PACK_LOAD.invoker()).event(server));
        DataPackPostProcess.AFTER_DATA_PACK_LOAD.addPhaseOrdering(DataPackPostProcess.FIRST, DataPackPostProcess.SECOND);
        DataPackPostProcess.AFTER_DATA_PACK_LOAD.register(DataPackPostProcess.SECOND, server -> ((DataPackPostProcess.SyncToPlayers)DataPackPostProcess.SYNC.invoker()).sync(server, new HashSet<class_3222>(server.method_3760().method_14571())));
        MeatLibRegistration.flush();
        ScreenReady.init();
    }

    public static boolean isClient() {
        return Thread.currentThread().getName().equals("Render thread");
    }

    static {
        VOID_LOOKUP = BlockApiLookup.get((class_2960)new class_2960("neepmeat", "sided_void"), Void.class, Void.class);
    }
}

