/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client;

import com.neep.neepmeat.mixin.client.SpriteContentsAccessor;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1011;
import net.minecraft.class_1058;

@Environment(value=EnvType.CLIENT)
public class MeatlibFluidRendering {
    private static final Map<FluidVariant, Integer> MAP = new HashMap<FluidVariant, Integer>();

    private MeatlibFluidRendering() {
    }

    public static int getColor(FluidVariant fluid) {
        return MAP.computeIfAbsent(fluid, MeatlibFluidRendering::createTint);
    }

    public static int getColor(FluidVariant fluid, boolean brighten) {
        int col = MeatlibFluidRendering.getColor(fluid);
        if (brighten) {
            col = MeatlibFluidRendering.brighten(col, 1.5f);
        }
        return col;
    }

    public static int brighten(int col, float fac) {
        float a = col >> 24 & 0xFF;
        float r = (float)(col >> 16 & 0xFF) * fac;
        float g = (float)(col >> 8 & 0xFF) * fac;
        float b = (float)(col & 0xFF) * fac;
        float max = Math.max(r, Math.max(b, a));
        r = r / max * 255.0f;
        g = g / max * 255.0f;
        b = b / max * 255.0f;
        return MeatlibFluidRendering.pack((int)r, (int)g, (int)b, (int)a);
    }

    private static int createTint(FluidVariant fluid) {
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        if (sprite != null) {
            return MeatlibFluidRendering.calculateAverage(sprite, FluidVariantRendering.getColor((FluidVariant)fluid));
        }
        return 0xFFFFFF;
    }

    public static int pack(int r, int g, int b, int a) {
        return a << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int calculateAverage(class_1058 sprite, int tint) {
        class_1011 image = ((SpriteContentsAccessor)sprite).getImages()[0];
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (tint != -1) {
            red = (float)(tint >> 16 & 0xFF) / 255.0f;
            green = (float)(tint >> 8 & 0xFF) / 255.0f;
            blue = (float)(tint & 0xFF) / 255.0f;
        }
        int pixels = 0;
        int cumR = 0;
        int cumG = 0;
        int cumB = 0;
        for (int i = 0; i < image.method_4307(); ++i) {
            for (int j = 0; j < image.method_4323(); ++j) {
                int agbr = image.method_4315(i, j);
                int alpha = agbr >> 24;
                if (alpha == 0) continue;
                cumR += agbr & 0xFF;
                cumG += agbr >> 8 & 0xFF;
                cumB += agbr >> 16 & 0xFF;
                ++pixels;
            }
        }
        if (pixels == 0) {
            return -1;
        }
        cumR = (int)((float)cumR / (float)pixels * red);
        cumG = (int)((float)cumG / (float)pixels * green);
        cumB = (int)((float)cumB / (float)pixels * blue);
        return MeatlibFluidRendering.pack(cumR, cumG, cumB, 255);
    }
}

