/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.widget;

import com.neep.meatlib.client.screen.widget.NumberTextField;
import com.neep.meatlib.client.screen.widget.ParentWidget;
import com.neep.meatlib.screen.NumberListConfigHandler;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.client.screen.util.Background;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public abstract class NumberListConfigWidget<T extends Number, L extends List<T>>
extends ParentWidget {
    protected final NumberListConfigHandler<T, L> handler;
    protected final List<TextField> textFields = new ObjectArrayList();

    public NumberListConfigWidget(int x, int y, int w, int h, NumberListConfigHandler<T, L> handler) {
        super(x, y, w, h);
        this.handler = handler;
        handler.updateParamsS2C.receiver(this::updateParams);
        this.createTextFields();
    }

    protected abstract void createTextFields();

    protected abstract L createList();

    protected abstract T zero();

    protected abstract T parseValue(String var1);

    protected abstract String valueToString(T var1);

    protected abstract boolean validString(String var1);

    protected abstract T applyScroll(String var1, Double var2);

    protected float scrollMultiplier() {
        return class_437.method_25442() ? 1.0f : 10.0f;
    }

    protected <W extends TextField> W addTextField(W field) {
        this.textFields.add(field);
        return field;
    }

    @Override
    public void close() {
        super.close();
        this.update();
    }

    public void update() {
        try {
            L values = this.createList();
            for (TextField field : this.textFields) {
                String text = field.text();
                T parsed = !text.isEmpty() ? this.parseValue(text) : this.zero();
                values.add(parsed);
            }
            this.handler.receiveParamsC2S.emitter().update(values);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void init() {
        super.init();
        Background background = new Background(this.x, this.y, this.w, this.h, 6);
        this.addChild(background);
        int yOff = this.y;
        for (TextField field : this.textFields) {
            this.addChild(field);
            field.setDims(this.x, yOff, this.w(), field.h());
            field.drawFancyBackground(false);
            yOff += field.h() + 1;
        }
        this.h = yOff - this.y;
        background.setH(this.h);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.isFocused() && keyCode == 69) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void tick() {
    }

    @Override
    public void method_37020(class_6382 builder) {
    }

    @Override
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void setW(int w) {
        this.w = w;
    }

    private void updateParams(L values) {
        if (values.size() != this.textFields.size()) {
            NeepMeat.LOGGER.error("RangeConfigWidget: Incorrect number of values received");
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            TextField field = this.textFields.get(i);
            field.setNumberText((Number)values.get(i));
            field.dirty = false;
        }
    }

    protected class TextField
    extends NumberTextField<T> {
        public TextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 prefix) {
            super(textRenderer, x, y, width, height, prefix, NumberListConfigWidget.this::update, NumberListConfigWidget.this::validString, NumberListConfigWidget.this::valueToString, NumberListConfigWidget.this::applyScroll);
        }
    }
}

