/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.documentation;

import com.neep.meatlib.MeatLib;
import com.neep.meatlib.documentation.DocumentationLarkdownVisitor;
import com.neep.meatlib.larkdown.LarkdownContent;
import com.neep.meatlib.larkdown.LarkdownParseException;
import com.neep.meatlib.larkdown.LarkdownParser;
import com.neep.meatlib.larkdown.command.LarkdownCommands;
import com.neep.meatlib.larkdown.content.HeadingLarkdownContent;
import com.neep.meatlib.larkdown.parser.LineCommandParser;
import com.neep.meatlib.larkdown.parser.TextContentParser;
import com.neep.neepmeat.guide.article.Article;
import com.neep.neepmeat.thord.documentation.CategoryCommand;
import com.neep.neepmeat.thord.documentation.CategoryLarkdownContent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class DocumentationReloadListener
implements SimpleSynchronousResourceReloadListener {
    private final String folder;
    private final Map<String, Category> catEntries = new LinkedHashMap<String, Category>();
    private final Map<String, Description> docEntries = new LinkedHashMap<String, Description>();

    public DocumentationReloadListener(String folder) {
        this.folder = folder;
    }

    @Nullable
    public Category get(String id) {
        return this.catEntries.get(id);
    }

    public Collection<Category> getEntries() {
        return this.catEntries.values();
    }

    public class_2960 getFabricId() {
        return new class_2960("neepmeat", "documentation");
    }

    private Predicate<class_2960> pathPredicate(String language) {
        return identifier -> {
            String path = identifier.method_12832();
            return path.contains(language + "/") && path.endsWith(".md");
        };
    }

    public void method_14491(class_3300 manager) {
        this.catEntries.clear();
        this.docEntries.clear();
        String language = class_310.method_1551().method_1526().method_4669().getCode();
        LarkdownCommands.Mutable commands = new LarkdownCommands.Mutable();
        commands.register("cat", new CategoryCommand());
        List<LarkdownParser.ContentParser> parsers = List.of(new LarkdownParser.HeadingContentParser(), new LarkdownParser.BulletContentParser(), new LarkdownParser.CodeContentParser(), new LineCommandParser(commands), new TextContentParser());
        this.process(manager, "en_us", parsers);
        if (!language.equals("en_us")) {
            this.process(manager, language, parsers);
        }
    }

    private void process(class_3300 manager, String language, List<LarkdownParser.ContentParser> parsers) {
        Map foundIds = manager.method_14488("docs/" + this.folder, this.pathPredicate(language));
        DocumentationLarkdownVisitor visitor = new DocumentationLarkdownVisitor();
        for (Map.Entry found : foundIds.entrySet()) {
            try {
                InputStream stream = ((class_3298)found.getValue()).method_14482();
                try {
                    LarkdownParser parser = new LarkdownParser(new InputStreamReader(stream, StandardCharsets.UTF_8), parsers);
                    List<LarkdownContent> contents = parser.getContents();
                    ObjectArrayList entries = new ObjectArrayList();
                    entries.add(new Category("", "", (List<Description>)new ObjectArrayList()));
                    for (int i = 0; i < contents.size(); ++i) {
                        HeadingLarkdownContent heading;
                        LarkdownContent content = contents.get(i);
                        if (content instanceof CategoryLarkdownContent) {
                            CategoryLarkdownContent category = (CategoryLarkdownContent)content;
                            i = this.readCategoryEntry(i, category.id(), contents, ((List)entries)::add) - 1;
                            continue;
                        }
                        if (!(content instanceof HeadingLarkdownContent) || (heading = (HeadingLarkdownContent)content).level() != 2) continue;
                        String name = heading.text().toLowerCase().split(" ")[0];
                        i = this.readDocEntry(visitor, i, name, contents, (Category)entries.get(entries.size() - 1)) - 1;
                    }
                    for (Category entry : entries) {
                        this.catEntries.put(entry.id, entry);
                        for (Description desc : entry.contents) {
                            this.docEntries.put(desc.name, desc);
                        }
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (LarkdownParseException | IOException e) {
                MeatLib.LOGGER.error("Error while loading markdown file {}", (Object)((class_2960)found.getKey()).toString(), (Object)e);
            }
        }
    }

    private int readCategoryEntry(int current, String id, List<LarkdownContent> input, Consumer<Category> consumer) {
        int next = current + 1;
        if (next < input.size()) {
            HeadingLarkdownContent heading;
            LarkdownContent larkdownContent = input.get(next);
            if (larkdownContent instanceof HeadingLarkdownContent && (heading = (HeadingLarkdownContent)larkdownContent).level() == 1) {
                consumer.accept(new Category(id, heading.text(), (List<Description>)new ObjectArrayList()));
            }
            return next + 1;
        }
        return next;
    }

    private int readDocEntry(DocumentationLarkdownVisitor visitor, int current, String name, List<LarkdownContent> input, Category entry) {
        LarkdownContent content;
        int i;
        ObjectArrayList contents = new ObjectArrayList();
        for (i = current; i < input.size() && (!this.endEntry(content = input.get(i)) || contents.isEmpty()); ++i) {
            contents.add(content);
        }
        entry.contents.add(new Description(name, visitor.apply((List<LarkdownContent>)contents)));
        return i;
    }

    private boolean endEntry(LarkdownContent content) {
        return content instanceof HeadingLarkdownContent || content instanceof CategoryLarkdownContent;
    }

    public record Category(String id, String name, List<Description> contents) {
    }

    public record Description(String name, List<Article.Content> contents) {
    }
}

