/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.graphics.client;

import com.neep.meatlib.graphics.GraphicsEffect;
import com.neep.meatlib.graphics.GraphicsEffectType;
import com.neep.meatlib.graphics.GraphicsEffects;
import com.neep.meatlib.graphics.client.GraphicsEffectFactory;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class GraphicsEffectClient {
    public static List<GraphicsEffect> EFFECTS = new ArrayList<GraphicsEffect>();
    private static final Int2ObjectMap<GraphicsEffectFactory> FACTORIES = new Int2ObjectOpenHashMap();

    public static void addEffect(GraphicsEffect effect) {
        EFFECTS.add(effect);
    }

    public static void init() {
        ClientTickEvents.END_WORLD_TICK.register(ctx -> {
            class_638 world = class_310.method_1551().field_1687;
            EFFECTS.removeIf(effect -> effect.isRemoved() || effect.getWorld() != world);
            EFFECTS.forEach(GraphicsEffect::tick);
        });
        WorldRenderEvents.AFTER_ENTITIES.register(ctx -> {
            class_4587 matrices = ctx.matrixStack();
            class_4597 consumers = ctx.consumers();
            EFFECTS.forEach(effect -> effect.render(ctx.camera(), matrices, consumers, ctx.tickDelta()));
        });
        WorldRenderEvents.AFTER_TRANSLUCENT.register(ctx -> {
            class_4587 matrices = ctx.matrixStack();
            class_4597 consumers = ctx.consumers();
            EFFECTS.forEach(effect -> effect.renderAfter(ctx.camera(), matrices, consumers, ctx.tickDelta()));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GraphicsEffects.CHANNEL_ID, (client, handler, byteBuf, responseSender) -> {
            UUID uuid = byteBuf.method_10790();
            class_2960 worldId = byteBuf.method_10810();
            int rawId = byteBuf.method_10816();
            class_2540 copiedBuf = PacketByteBufs.copy((ByteBuf)byteBuf);
            client.execute(() -> {
                class_638 world = class_310.method_1551().field_1687;
                if (world == null) {
                    throw new IllegalStateException("Tried to spawn effect in a null world!");
                }
                if (world.method_27983().method_29177().equals((Object)worldId)) {
                    GraphicsEffect effect = ((GraphicsEffectFactory)FACTORIES.get(rawId)).create((class_1937)world, uuid, copiedBuf);
                    GraphicsEffectClient.addEffect(effect);
                }
            });
        });
    }

    public static GraphicsEffectFactory registerEffect(GraphicsEffectType type, GraphicsEffectFactory factory) {
        FACTORIES.put(GraphicsEffects.GRAPHICS_EFFECTS.method_10206((Object)type), (Object)factory);
        return factory;
    }
}

