/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.recipe.ingredient;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.neep.meatlib.recipe.ingredient.IngredientType;
import com.neep.meatlib.recipe.ingredient.RecipeInput;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInputSerialiser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class RegistryRecipeInput<R>
implements RecipeInput<R, StorageView<? extends TransferVariant<?>>> {
    protected final RegistryRecipeInputSerialiser<R> serialiser;
    protected final IngredientType<?> type;
    protected Entry<R> entry;
    protected final long amount;
    @Nullable
    protected R[] matchingObjects;

    protected RegistryRecipeInput(Entry<R> entry, long amount, RegistryRecipeInputSerialiser<R> serialiser, IngredientType<?> type) {
        this.entry = entry;
        this.amount = amount;
        this.serialiser = serialiser;
        this.type = type;
    }

    public static <R> RegistryRecipeInput<R> fromBuffer(class_2540 buf) {
        class_2960 type = new class_2960(buf.method_19772());
        RecipeInput.Serialiser serialiser = (RecipeInput.Serialiser)RecipeInputs.SERIALISERS.method_10223(type);
        if (serialiser instanceof RegistryRecipeInputSerialiser) {
            RegistryRecipeInputSerialiser serialiser1 = (RegistryRecipeInputSerialiser)serialiser;
            return serialiser1.fromBuffer(buf);
        }
        throw new IllegalStateException("Error reading recipe packet: invalid type");
    }

    public static <R> RegistryRecipeInput<R> fromJson(RegistryRecipeInputSerialiser<R> serialiser, JsonObject json) {
        return (RegistryRecipeInput)serialiser.fromJson(json);
    }

    public static RegistryRecipeInput<?> fromJson(JsonObject json) {
        if (!json.has("type")) {
            throw new JsonParseException("Recipe input does not specify resource type.");
        }
        class_2960 type = new class_2960(class_3518.method_15265((JsonObject)json, (String)"type"));
        RecipeInput.Serialiser serialiser = (RecipeInput.Serialiser)RecipeInputs.SERIALISERS.method_10223(type);
        if (serialiser == null) {
            throw new JsonParseException("Unknown resource type '" + String.valueOf(type) + "'");
        }
        return (RegistryRecipeInput)serialiser.fromJson(json);
    }

    public <V extends TransferVariant<R>> boolean extract(Storage<V> storage, Function<R, V> function, TransactionContext transaction) {
        @Nullable T item = this.getFirstMatching(storage, transaction).orElse(null);
        if (item == null) {
            return false;
        }
        long extracted = storage.extract((Object)((TransferVariant)function.apply(item)), this.amount(), transaction);
        return extracted == this.amount();
    }

    public RegistryRecipeInputSerialiser<R> getSerialiser() {
        return this.serialiser;
    }

    @Override
    public IngredientType<?> getType() {
        return this.type;
    }

    @Override
    public void write(class_2540 buf) {
        this.serialiser.write(buf, this);
    }

    public long amount() {
        return this.amount;
    }

    @Override
    public boolean isEmpty() {
        return this.amount == 0L || this == RecipeInputs.EMPTY;
    }

    public void cacheMatching() {
        if (this.matchingObjects == null) {
            this.matchingObjects = this.entry.getMatching().stream().distinct().toArray();
        }
    }

    @Override
    public boolean test(StorageView<? extends TransferVariant<?>> storageView) {
        this.cacheMatching();
        return Arrays.stream(this.matchingObjects).anyMatch(o -> ((TransferVariant)storageView.getResource()).getObject().equals(o));
    }

    public boolean testStorage(Storage<? extends TransferVariant<?>> storage) {
        this.cacheMatching();
        for (StorageView view : storage) {
            if (!Arrays.stream(this.matchingObjects).anyMatch(o -> ((TransferVariant)view.getResource()).getObject().equals(o))) continue;
            return true;
        }
        return false;
    }

    public boolean test(TransferVariant<?> variant, long amount) {
        this.cacheMatching();
        return Arrays.stream(this.matchingObjects).anyMatch(o -> variant.getObject().equals(o)) && amount >= this.amount();
    }

    public Optional<R> getFirstMatching(StorageView<? extends TransferVariant<R>> view) {
        this.cacheMatching();
        return Arrays.stream(this.matchingObjects).filter(r -> ((TransferVariant)view.getResource()).getObject().equals(r)).findFirst();
    }

    public Optional<R> getFirstMatching(Storage<? extends TransferVariant<?>> storage, TransactionContext transaction) {
        this.cacheMatching();
        for (StorageView view : storage) {
            Optional<Object> optional = Arrays.stream(this.matchingObjects).filter(r -> ((TransferVariant)view.getResource()).getObject().equals(r)).findFirst();
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public <V extends TransferVariant<R>> Optional<V> getFirstMatching(Storage<V> storage, class_2487 nbt, BiFunction<R, class_2487, V> func, TransactionContext transaction) {
        this.cacheMatching();
        for (StorageView view : storage) {
            Optional<Object> optional = Arrays.stream(this.matchingObjects).filter(r -> {
                TransferVariant variant = (TransferVariant)view.getResource();
                return variant.getObject().equals(r) && variant.nbtMatches(nbt);
            }).findFirst();
            if (!optional.isPresent()) continue;
            return Optional.of((TransferVariant)func.apply(optional.get(), nbt));
        }
        return Optional.empty();
    }

    public Collection<R> getAll() {
        return this.entry.getMatching();
    }

    public R[] getMatching() {
        return this.matchingObjects;
    }

    public static interface Entry<T> {
        public static final Entry<Object> EMPTY = () -> Collections.EMPTY_SET;

        public Collection<T> getMatching();
    }

    public static class ResourceEntry<T>
    implements Entry<T> {
        protected T object;

        public ResourceEntry(T resource) {
            this.object = resource;
        }

        public T getObject() {
            return this.object;
        }

        @Override
        public Collection<T> getMatching() {
            return List.of(this.object);
        }
    }

    public static class TagEntry<T>
    implements Entry<T> {
        protected class_6862<T> tag;

        TagEntry(class_6862<T> tag) {
            this.tag = tag;
        }

        @Override
        public Collection<T> getMatching() {
            ArrayList<Object> list = new ArrayList<Object>();
            class_2378<T> registry = TagEntry.getRegistry(this.tag.comp_326());
            for (class_6880 registryEntry : registry.method_40286(this.tag)) {
                list.add(registryEntry.comp_349());
            }
            return list;
        }

        public static <T> class_2378<T> getRegistry(class_5321<? extends class_2378<T>> key) {
            if (class_2378.field_11142.method_30517().equals(key)) {
                return class_2378.field_11142;
            }
            if (class_2378.field_11154.method_30517().equals(key)) {
                return class_2378.field_11154;
            }
            throw new NotImplementedException();
        }

        public class_6862<T> getTag() {
            return this.tag;
        }
    }
}

