/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.storage.ResourcePredicate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class MeatlibStorageUtil {
    public static final Codec<ItemVariant> ITEM_VARIANT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_11142.method_39673().fieldOf("item").forGetter(ItemVariant::getItem), (App)Codec.optionalField((String)"nbt", (Codec)class_2487.field_25128).forGetter(v -> Optional.ofNullable(v.getNbt()))).apply((Applicative)instance, (item, opt) -> ItemVariant.of((class_1935)item, (class_2487)opt.orElse(null))));

    @Nullable
    public static <T> ResourceAmount<T> findAndExtractContent(Storage<T> storage, long maxAmount, TransactionContext transaction, ResourcePredicate<T> predicate) {
        for (StorageView view : storage) {
            long insertable;
            Object resource = view.getResource();
            if (view.isResourceBlank() || (insertable = predicate.tryTest(resource, Math.min(maxAmount, view.getAmount()))) <= 0L) continue;
            Transaction inner = transaction.openNested();
            try {
                long extracted = view.extract(resource, insertable, (TransactionContext)inner);
                if (extracted <= 0L || extracted > insertable) continue;
                inner.commit();
                ResourceAmount resourceAmount = new ResourceAmount(resource, extracted);
                return resourceAmount;
            }
            finally {
                if (inner == null) continue;
                inner.close();
            }
        }
        return null;
    }

    @Nullable
    public static <T> T findStoredResourceForInsertion(@Nullable Storage<T> storage, Storage<T> insertTo, T blank) {
        if (storage == null) {
            return null;
        }
        HashSet<Object> things = new HashSet<Object>();
        things.add(blank);
        for (StorageView view : insertTo) {
            Object resource = view.getResource();
            if (resource.equals(blank)) {
                return (T)MeatlibStorageUtil.findStoredResource(storage, v -> true);
            }
            things.add(resource);
        }
        for (StorageView view : storage) {
            if (view.isResourceBlank() || !things.contains(view.getResource())) continue;
            return (T)view.getResource();
        }
        return null;
    }

    @Nullable
    public static <T> ResourceAmount<T> findExtractableContent(@Nullable Storage<T> storage, BiPredicate<TransactionContext, T> filter, @Nullable TransactionContext transaction) {
        long extractableAmount;
        T extractableResource = MeatlibStorageUtil.findExtractableResource(storage, (t, r, l) -> filter.test((TransactionContext)t, (Object)r), transaction);
        if (extractableResource != null && (extractableAmount = MeatlibStorageUtil.simulateExtract(storage, extractableResource, Long.MAX_VALUE, transaction)) > 0L) {
            return new ResourceAmount(extractableResource, extractableAmount);
        }
        return null;
    }

    @Nullable
    public static <T> T findStoredResource(@Nullable Storage<T> storage, Predicate<T> filter) {
        Objects.requireNonNull(filter, "Filter may not be null");
        if (storage == null) {
            return null;
        }
        for (StorageView view : storage) {
            if (view.isResourceBlank() || view.getAmount() <= 0L || !filter.test(view.getResource())) continue;
            return (T)view.getResource();
        }
        return null;
    }

    public static <T> long simulateExtract(Storage<T> storage, T resource, long maxAmount, TransactionContext transaction) {
        return storage.simulateExtract(resource, maxAmount, transaction);
    }

    public static <T> long simulateInsert(Storage<T> storage, T resource, long amount, TransactionContext transaction) {
        return storage.simulateInsert(resource, amount, transaction);
    }

    @Nullable
    public static <T> T findExtractableResource(@Nullable Storage<T> storage, TriFunction<TransactionContext, T, Long, Boolean> filter, @Nullable TransactionContext transaction) {
        if (storage == null) {
            return null;
        }
        try (Transaction nested = Transaction.openNested((TransactionContext)transaction);){
            for (StorageView view : storage) {
                Object resource = view.getResource();
                if (view.isResourceBlank() || !((Boolean)filter.apply((Object)nested, resource, (Object)view.getAmount())).booleanValue() || view.extract(resource, Long.MAX_VALUE, (TransactionContext)nested) <= 0L) continue;
                Object object = resource;
                return (T)object;
            }
        }
        return null;
    }

    public static void scatterAmount(class_1937 world, class_2338 pos, @Nullable ResourceAmount<ItemVariant> resourceAmount) {
        if (resourceAmount != null) {
            class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)((ItemVariant)resourceAmount.resource()).toStack((int)resourceAmount.amount()));
        }
    }

    public static void scatter(class_1937 world, class_2338 pos, @Nullable class_1799 stack) {
        if (stack != null) {
            class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)stack);
        }
    }

    public static class_2487 itemAmountToNbt(ResourceAmount<ItemVariant> resourceAmount) {
        class_2487 nbt = ((ItemVariant)resourceAmount.resource()).toNbt();
        nbt.method_10544("amount", resourceAmount.amount());
        return nbt;
    }

    public static class_2487 fluidAmountToNbt(ResourceAmount<FluidVariant> resourceAmount) {
        class_2487 nbt = ((FluidVariant)resourceAmount.resource()).toNbt();
        nbt.method_10544("amount", resourceAmount.amount());
        return nbt;
    }

    public static ResourceAmount<ItemVariant> amountFromNbt(class_2487 nbt) {
        ItemVariant variant = ItemVariant.fromNbt((class_2487)nbt);
        return new ResourceAmount((Object)variant, nbt.method_10537("amount"));
    }

    public static ResourceAmount<FluidVariant> fluidAmountFromNbt(class_2487 nbt) {
        FluidVariant variant = FluidVariant.fromNbt((class_2487)nbt);
        return new ResourceAmount((Object)variant, nbt.method_10537("amount"));
    }

    public static void scatter(class_1937 world, class_2338 pos, Storage<ItemVariant> storage) {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : storage) {
                ItemVariant variant = (ItemVariant)view.getResource();
                if (variant.isBlank() || view.getAmount() <= 0L) continue;
                long extracted = view.extract((Object)((ItemVariant)view.getResource()), Long.MAX_VALUE, (TransactionContext)transaction);
                class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)variant.toStack((int)extracted));
            }
        }
    }

    public static void scatterNoTransaction(class_1937 world, class_2338 pos, Storage<ItemVariant> storage) {
        for (StorageView view : storage) {
            class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)((ItemVariant)view.getResource()).toStack((int)view.getAmount()));
        }
    }

    public static <T> ResourcePredicate<T> insertionPredicate(@Nullable Storage<T> storage) {
        if (storage == null) {
            return (v, a) -> a;
        }
        HashSet<Object> found = new HashSet<Object>();
        for (StorageView view : storage) {
            if (view.isResourceBlank()) {
                return (v, a) -> a;
            }
            found.add(view.getResource());
        }
        return (r, a) -> found.contains(r) ? a : 0L;
    }

    public static <T> Predicate<T> deepInsertionPredicate(@Nullable Storage<T> storage, long maxAmount, TransactionContext transaction) {
        if (storage == null) {
            return v -> true;
        }
        HashSet<Object> found = new HashSet<Object>();
        for (StorageView view : storage) {
            if (view.isResourceBlank()) {
                return v -> true;
            }
            try (Transaction inner = transaction.openNested();){
                storage.insert(view.getResource(), maxAmount, (TransactionContext)inner);
            }
            found.add(view.getResource());
        }
        return found::contains;
    }
}

