/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.util.graph;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.neep.meatlib.util.graph.ConnectablePipe;
import com.neep.meatlib.util.graph.PipeVertex;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class PipeGraphUtil {
    public static <T extends PipeVertex> void linkVertices(class_3218 world, class_2338 pos, class_2680 state, ConnectablePipe pipe, PipeVertex.Lookup<T> lookup, ConnectablePipe.Find find) {
        ArrayList toConnect = Lists.newArrayList();
        for (class_2350 direction : pipe.getConnections(state)) {
            Pair<T, class_2350> nextVertex = PipeGraphUtil.findNextVertex(world, pos, direction, lookup, find);
            if (nextVertex == null) continue;
            toConnect.add(nextVertex);
        }
        if (toConnect.size() != 2) {
            return;
        }
        Pair vertex1 = (Pair)toConnect.get(0);
        Pair vertex2 = (Pair)toConnect.get(1);
        ((PipeVertex)vertex1.first()).setAdjVertex(((class_2350)vertex1.second()).method_10146(), (PipeVertex)vertex2.first());
        ((PipeVertex)vertex2.first()).setAdjVertex(((class_2350)vertex2.second()).method_10146(), (PipeVertex)vertex1.first());
        PipeGraphUtil.jankParticles(world, (PipeVertex)vertex1.first(), true);
        PipeGraphUtil.jankParticles(world, (PipeVertex)vertex2.first(), true);
    }

    public static void jankParticles(class_3218 world, PipeVertex vertex, boolean add) {
    }

    public static void moreJankParticles(class_3218 world, PipeVertex vertex) {
    }

    public static <T extends PipeVertex> Pair<T, class_2350> findNextVertex(class_3218 world, class_2338 pos, class_2350 out, PipeVertex.Lookup<T> lookup, ConnectablePipe.Find find) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(Pair.of((Object)pos.method_10093(out), (Object)out));
        visited.add(pos.method_10093(out));
        visited.add(pos);
        while (!queue.isEmpty()) {
            Pair current = (Pair)queue.poll();
            class_2680 currentState = world.method_8320((class_2338)current.first());
            ConnectablePipe pipe = find.find((class_1937)world, (class_2338)current.first(), currentState);
            if (pipe == null) {
                return null;
            }
            int connections = pipe.countConnections(currentState);
            T vertex = lookup.find(world, (class_2338)current.first());
            if (vertex == null) {
                throw new IllegalStateException("Pipe %s does not have valid vertex lookup. Fix this.".formatted(pipe));
            }
            if (connections > 2 || !vertex.canSimplify()) {
                return Pair.of(vertex, (Object)((class_2350)current.second()).method_10153());
            }
            class_2338.class_2339 offsetPos = ((class_2338)current.first()).method_25503();
            for (class_2350 direction : pipe.getConnections(currentState)) {
                T offsetVertex;
                offsetPos.method_25505((class_2382)current.first(), direction);
                if (visited.contains(offsetPos) || (offsetVertex = lookup.find(world, (class_2338)offsetPos)) == null) continue;
                visited.add(offsetPos.method_10062());
                queue.add(Pair.of((Object)offsetPos.method_10062(), (Object)direction));
            }
        }
        return null;
    }

    public static void eraseHiddenFromNeighbours(class_3218 world, class_2338 pos, class_2680 state, ConnectablePipe pipe, ConnectablePipe.Find find) {
        List<Pair<PipeVertex, class_2350>> toNotify = PipeGraphUtil.getNearestVertices(world, pos, state, pipe, find);
        for (Pair<PipeVertex, class_2350> pair : toNotify) {
            ((PipeVertex)pair.first()).setAdjVertex(((class_2350)pair.second()).method_10153().ordinal(), null);
            PipeGraphUtil.jankParticles(world, (PipeVertex)pair.first(), false);
        }
    }

    public static List<Pair<PipeVertex, class_2350>> getNearestVertices(class_3218 world, class_2338 start, class_2680 oldState, ConnectablePipe startPipe, ConnectablePipe.Find find) {
        ArrayList vertices = Lists.newArrayList();
        HashSet visited = Sets.newHashSet();
        ArrayDeque stack = Queues.newArrayDeque();
        ArrayDeque stateQueue = Queues.newArrayDeque();
        ArrayDeque pipeQueue = Queues.newArrayDeque();
        PipeVertex startVertex = startPipe.getPipeVertex(world, start, oldState);
        if (!startVertex.canSimplify()) {
            return vertices;
        }
        visited.add(start);
        stack.add(start);
        pipeQueue.add(startPipe);
        stateQueue.add(oldState);
        while (!stack.isEmpty()) {
            class_2338 current = (class_2338)stack.poll();
            ConnectablePipe currentPipe = (ConnectablePipe)pipeQueue.poll();
            class_2680 currentState = (class_2680)stateQueue.poll();
            class_2338.class_2339 mutable = current.method_25503();
            for (class_2350 direction : currentPipe.getConnections(currentState)) {
                class_2680 offsetState;
                ConnectablePipe offsetPipe;
                mutable.method_25505((class_2382)current, direction);
                if (visited.contains(mutable) || (offsetPipe = find.find((class_1937)world, (class_2338)mutable, offsetState = world.method_8320((class_2338)mutable))) == null) continue;
                PipeVertex vertex = offsetPipe.getPipeVertex(world, (class_2338)mutable, offsetState);
                if (vertex != null && !vertex.canSimplify()) {
                    vertices.add(Pair.of((Object)vertex, (Object)direction));
                    continue;
                }
                visited.add(mutable.method_10062());
                stack.add(mutable.method_10062());
                stateQueue.add(offsetState);
                pipeQueue.add(offsetPipe);
            }
        }
        return vertices;
    }
}

