/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.client.network;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatweapons.component.MeatgunComponent;
import com.neep.meatweapons.init.MWComponents;
import com.neep.meatweapons.item.meatgun.Meatgun;
import com.neep.meatweapons.item.meatgun.MeatgunAnimationManager;
import com.neep.meatweapons.meatgun.AmmunitionType;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.meatgun.module.AmmunitionStoringModule;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.network.MeatgunNetwork;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.plc.PLCCols;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class MeatgunClient {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MeatgunNetwork.CHANNEL, (client, handler, buf, responseSender) -> {
            MeatgunNetwork.RecoilDirection direction = MeatgunNetwork.RecoilDirection.values()[buf.readInt()];
            float amount = buf.readFloat();
            float horAmount = buf.readFloat();
            float returnSpeed = buf.readFloat();
            float horReturnSpeed = buf.readFloat();
            class_1268 hand = class_1268.values()[buf.method_10816()];
            client.execute(() -> {
                MeatgunComponent component = hand == class_1268.field_5808 ? (MeatgunComponent)MWComponents.MEATGUN.getNullable((Object)client.field_1724.method_6047()) : (MeatgunComponent)MWComponents.MEATGUN.getNullable((Object)client.field_1724.method_6079());
                if (component != null) {
                    component.getRecoil().set(direction, amount, horAmount, returnSpeed, horReturnSpeed);
                }
            });
        });
        MeatgunNetwork.SEND_ANIMATION.receiver(EnvType.CLIENT, MeatgunClient::receiveAnimation);
        MeatgunNetwork.SYNC_MODULE.receiverHandler(EnvType.CLIENT, MeatgunClient::receiveSync);
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (((Boolean)NeepMeat.CONFIG.meatgunAmmoOnModel.getRealValue()).booleanValue()) {
                return;
            }
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            if (player.method_6047().method_7909() instanceof Meatgun || player.method_6079().method_7909() instanceof Meatgun) {
                MeatgunComponent component1 = (MeatgunComponent)MWComponents.MEATGUN.getNullable((Object)player.method_6047());
                MeatgunComponent component2 = (MeatgunComponent)MWComponents.MEATGUN.getNullable((Object)player.method_6079());
                drawContext.method_22903();
                drawContext.method_22904(0.0, (double)client.method_22683().method_4502(), 0.0);
                if (component1 != null) {
                    class_4597.class_4598 vcp = client.method_22940().method_23000();
                    MeatgunClient.renderHud(drawContext, (class_4597)vcp, tickDelta, component1.getRootHolder(), true);
                    vcp.method_22993();
                } else if (component2 != null) {
                    class_4597.class_4598 vcp = client.method_22940().method_23000();
                    MeatgunClient.renderHud(drawContext, (class_4597)vcp, tickDelta, component2.getRootHolder(), true);
                    vcp.method_22993();
                }
                drawContext.method_22909();
            }
        });
    }

    private static MeatgunNetwork.SyncModule receiveSync(class_1657 player, class_2540 buf, PacketSender packetSender) {
        return (slot, uuid, nbt) -> {
            MeatgunModule module;
            class_1799 stack = player.field_7514.method_5438(slot);
            MeatgunComponent component = (MeatgunComponent)MWComponents.MEATGUN.getNullable((Object)stack);
            if (component != null && (module = component.getRootHolder().moduleCache().findModule(uuid)) != null) {
                module.readNbt(nbt);
            }
        };
    }

    public static void renderHud(class_4587 drawContext, class_4597 vcp, float tickDelta, RootModuleHolder holder, boolean bottom) {
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        Map<AmmunitionType, List<AmmunitionStoringModule>> map = holder.moduleCache().getAmmo();
        int lines = 0;
        Objects.requireNonNull(textRenderer);
        int stride = 9 + 1;
        for (List<AmmunitionStoringModule> value : map.values()) {
            if (value.isEmpty()) continue;
            ++lines;
        }
        if (lines == 0) {
            return;
        }
        int col = PLCCols.BORDER.col & 0x88FFFFFF;
        int width = 60;
        int height = lines * stride + 2;
        drawContext.method_22903();
        if (bottom) {
            drawContext.method_22904(0.0, (double)(-height), 0.0);
        }
        drawContext.method_22904(0.0, 0.0, -0.01);
        class_332.method_25294((class_4587)drawContext, (int)-1, (int)-1, (int)(width + 1), (int)(height + 1), (int)0x30000000);
        drawContext.method_22904(0.0, 0.0, 0.01);
        GUIUtil.renderBorderInner(drawContext, 0, 0, width, height, col, 0);
        int textY = 2;
        drawContext.method_22903();
        drawContext.method_22905(1.0f, 1.0f, 0.1f);
        for (Map.Entry<AmmunitionType, List<AmmunitionStoringModule>> entry : map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            int amount = entry.getValue().stream().mapToInt(AmmunitionStoringModule::amount).sum();
            int col2 = col;
            if (amount == 0) {
                col2 = -1996554240;
            }
            GUIUtil.drawText(drawContext, textRenderer, entry.getKey().shortName() + " " + amount, 2.0f, (float)textY, col2, true);
            textY += stride;
        }
        drawContext.method_22909();
        drawContext.method_22909();
    }

    private static void receiveAnimation(String name, class_2540 buf) {
        MeatgunAnimationManager animationManager;
        class_310 client = class_310.method_1551();
        MeatgunComponent component1 = (MeatgunComponent)MWComponents.MEATGUN.getNullable((Object)client.field_1724.method_6047());
        MeatgunComponent component2 = (MeatgunComponent)MWComponents.MEATGUN.getNullable((Object)client.field_1724.method_6079());
        if (component1 != null && (animationManager = component1.getAnimationManager()) != null) {
            animationManager.queue(name, buf);
        }
        if (component2 != null && (animationManager = component2.getAnimationManager()) != null) {
            animationManager.queue(name, buf);
        }
    }
}

