/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.client.particle;

import com.neep.meatlib.util.maths.Vector3f;
import com.neep.meatweapons.client.particle.MeatgunParticle;
import com.neep.meatweapons.client.renderer.meatgun.MeatgunParticleManager;
import com.neep.meatweapons.particle.MuzzleFlashParticleType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1162;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MuzzleFlashParticleFactory
implements class_707<MuzzleFlashParticleType.MuzzleFlashParticleEffect> {
    protected final class_4002 spriteProvider;
    private final class_5819 random;

    public MuzzleFlashParticleFactory(class_4002 spriteProvider) {
        this.spriteProvider = spriteProvider;
        this.random = class_5819.method_43047();
    }

    @Nullable
    public class_703 createParticle(MuzzleFlashParticleType.MuzzleFlashParticleEffect parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        class_1657 player = world.method_18470(parameters.getPlayerUUID());
        MuzzleFlashParticle particle = new MuzzleFlashParticle(world, player, x, y, z, parameters.dx, parameters.dy, parameters.dz, parameters.scale, parameters.maxAge);
        particle.method_18140(this.spriteProvider);
        return particle;
    }

    public static class MuzzleFlashParticle
    extends class_4003
    implements MeatgunParticle {
        protected final float scale0;
        protected final double x0;
        protected final double y0;
        protected final double z0;
        protected final class_1657 player;
        protected final float fpScale;

        protected MuzzleFlashParticle(class_638 clientWorld, @Nullable class_1657 player, double d, double e, double f, double dx, double dy, double dz, float fpScale, int maxAge) {
            super(clientWorld, d, e, f);
            this.player = player;
            this.field_3847 = maxAge;
            this.scale0 = this.field_17867 = 0.2f * (this.field_3840.method_43057() * 0.5f + 0.5f) * 2.0f;
            this.fpScale = fpScale;
            this.x0 = dx;
            this.y0 = dy;
            this.z0 = dz;
            if (player == class_310.method_1551().field_1724) {
                MeatgunParticleManager.add(this);
            }
        }

        public void method_3070() {
            super.method_3070();
        }

        public float method_18132(float tickDelta) {
            return class_3532.method_16439((float)(((float)this.field_3866 + tickDelta) / (float)this.field_3847), (float)this.scale0, (float)(this.scale0 * 0.8f));
        }

        public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
            if (this.player != null) {
                if (this.player == class_310.method_1551().field_1724) {
                    return;
                }
                this.field_3874 = this.player.method_33571().field_1352 + this.x0;
                this.field_3854 = this.player.method_33571().field_1351 + this.y0;
                this.field_3871 = this.player.method_33571().field_1350 + this.z0;
                this.field_3858 = this.field_3874;
                this.field_3838 = this.field_3854;
                this.field_3856 = this.field_3871;
            }
            super.method_3074(vertexConsumer, camera, tickDelta);
        }

        public class_3999 method_18122() {
            return class_3999.field_17829;
        }

        @Override
        public boolean isParticleRemoved() {
            return !this.method_3086();
        }

        @Override
        public void render(class_4587 matrices, class_4184 camera, class_4588 consumer, int overlay, float tickDelta) {
            float f = (float)this.x0;
            float g = (float)this.y0;
            float h = (float)this.z0;
            float i = this.method_18132(tickDelta) * this.fpScale;
            Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
            for (int j = 0; j < 4; ++j) {
                Vector3f vector3f = vector3fs[j];
                vector3f.mul(i);
                vector3f.add(f, g, h);
                class_1162 v4 = new class_1162(vector3f.x, vector3f.y, vector3f.z, 1.0f);
                v4.method_22674(matrices.method_23760().method_23761());
                vector3f.set(v4.method_4953(), v4.method_4956(), v4.method_4957());
            }
            float k = this.method_18133();
            float l = this.method_18134();
            float m = this.method_18135();
            float n = this.method_18136();
            int o = this.method_3068(tickDelta);
            consumer.method_22912(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22913(k, m).method_22922(overlay).method_22916(o).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            consumer.method_22912(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22913(l, m).method_22922(overlay).method_22916(o).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            consumer.method_22912(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22913(l, n).method_22922(overlay).method_22916(o).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            consumer.method_22912(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_22913(k, n).method_22922(overlay).method_22916(o).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        }
    }
}

