/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.client.renderer;

import com.google.common.collect.Lists;
import com.neep.meatweapons.client.model.AirtruckModel;
import com.neep.meatweapons.entity.AbstractVehicleEntity;
import com.neep.meatweapons.entity.AirtruckEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import software.bernie.geckolib3.compat.PatchouliCompat;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.resource.GeckoLibCache;
import software.bernie.geckolib3.util.AnimationUtils;

public class AirtruckEntityRenderer<T extends AirtruckEntity>
extends class_897<T>
implements IGeoRenderer<T> {
    protected GeoModelProvider<T> modelProvider;
    protected final List<GeoLayerRenderer<T>> layerRenderers = Lists.newArrayList();
    private class_2960 whTexture;
    private class_4597 rtb = null;

    public AirtruckEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.modelProvider = new AirtruckModel();
    }

    public class_2960 getTexture(T entity) {
        return this.getTextureLocation(entity);
    }

    public class_4597 getCurrentRTB() {
        return this.rtb;
    }

    public GeoModelProvider<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    public class_2960 getTextureLocation(T instance) {
        return this.modelProvider.getTextureResource(instance);
    }

    public class_2960 getTextureResource(T instance) {
        return this.getTextureLocation(instance);
    }

    public static float ease(float x) {
        return (double)x < 0.5 ? 2.0f * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0);
    }

    public void render(T entity, float entityYaw, float partialTicks, class_4587 stack, class_4597 bufferIn, int packedLightIn) {
        stack.method_22903();
        EntityModelData entityModelData = new EntityModelData();
        float f = class_3532.method_17821((float)partialTicks, (float)((AirtruckEntity)((Object)entity)).field_5982, (float)entity.method_36454());
        float f7 = this.handleRotationFloat(entity, partialTicks);
        this.applyRotations(entity, stack, f7, f, partialTicks);
        float f2 = ((AirtruckEntity)((Object)entity)).forwardsVelocity;
        Objects.requireNonNull(entity);
        float prop = f2 / 0.05f;
        GeckoLibCache.getInstance().parser.setValue("r_lf", () -> Math.signum(prop) * -AirtruckEntityRenderer.ease(Math.abs(prop)) * 20.0f);
        GeckoLibCache.getInstance().parser.setValue("r_rf", () -> Math.signum(prop) * -AirtruckEntityRenderer.ease(Math.abs(prop)) * 20.0f);
        GeckoLibCache.getInstance().parser.setValue("r_lb", () -> Math.signum(prop) * -AirtruckEntityRenderer.ease(Math.abs(prop)) * 20.0f);
        GeckoLibCache.getInstance().parser.setValue("r_rb", () -> Math.signum(prop) * -AirtruckEntityRenderer.ease(Math.abs(prop)) * 20.0f);
        AnimationEvent predicate = new AnimationEvent(entity, 0.0f, 0.0f, partialTicks, false, Collections.singletonList(entityModelData));
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelResource(entity));
        if (this.modelProvider instanceof IAnimatableModel) {
            ((IAnimatableModel)this.modelProvider).setCustomAnimations(entity, this.getInstanceId(entity));
        }
        stack.method_22904(0.0, (double)0.01f, 0.0);
        class_310.method_1551().method_1531().method_22813(this.getTexture(entity));
        Color renderColor = this.getRenderColor(entity, partialTicks, stack, bufferIn, null, packedLightIn);
        class_1921 renderType = this.getRenderType(entity, partialTicks, stack, bufferIn, null, packedLightIn, this.getTexture(entity));
        boolean invis = entity.method_5756((class_1657)class_310.method_1551().field_1724);
        this.render(model, entity, partialTicks, renderType, stack, bufferIn, null, packedLightIn, AirtruckEntityRenderer.getPackedOverlay(entity, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, invis ? 0.0f : (float)renderColor.getAlpha() / 255.0f);
        if (FabricLoader.getInstance().isModLoaded("patchouli")) {
            PatchouliCompat.patchouliLoaded((class_4587)stack);
        }
        stack.method_22909();
        super.method_3936(entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    public int getInstanceId(T animatable) {
        return animatable.method_5667().hashCode();
    }

    public void renderEarly(T animatable, class_4587 stackIn, float ticks, class_4597 renderTypeBuffer, class_4588 vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        this.rtb = renderTypeBuffer;
        this.whTexture = this.getTextureLocation(animatable);
        super.renderEarly(animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
    }

    protected void applyRotations(T entity, class_4587 matrices, float ageInTicks, float rotationYaw, float tickDelta) {
        class_4050 pose = entity.method_18376();
        matrices.method_22907(class_1160.field_20705.method_23214(180.0f - rotationYaw));
        matrices.method_22907(class_1160.field_20706.method_23214(((AbstractVehicleEntity)((Object)entity)).getRoll(tickDelta)));
        matrices.method_22907(class_1160.field_20702.method_23214(entity.method_5695(tickDelta)));
    }

    public static int getPackedOverlay(class_1297 livingEntityIn, float uIn) {
        return class_4608.method_23624((float)class_4608.method_23210((float)uIn), (boolean)false);
    }

    protected float handleRotationFloat(T livingBase, float partialTicks) {
        return (float)((AirtruckEntity)((Object)livingBase)).field_6012 + partialTicks;
    }

    public final boolean addLayer(GeoLayerRenderer<T> layer) {
        return this.layerRenderers.add(layer);
    }

    static {
        AnimationController.addModelFetcher(animatable -> {
            IAnimatableModel iAnimatableModel;
            if (animatable instanceof class_1297) {
                class_1297 entity = (class_1297)animatable;
                iAnimatableModel = (IAnimatableModel)AnimationUtils.getGeoModelForEntity((class_1297)entity);
            } else {
                iAnimatableModel = null;
            }
            return iAnimatableModel;
        });
    }
}

