/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.client.renderer;

import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.neep.meatlib.client.RotationAxis;
import com.neep.meatlib.util.maths.Matrix4f;
import com.neep.meatweapons.client.meatgun.RecoilManager;
import com.neep.meatweapons.client.meatgun.animation.MeatgunAnimation;
import com.neep.meatweapons.client.network.MeatgunClient;
import com.neep.meatweapons.client.particle.MeatgunParticle;
import com.neep.meatweapons.client.renderer.meatgun.MeatgunModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.MeatgunModuleRenderers;
import com.neep.meatweapons.client.renderer.meatgun.MeatgunParticleManager;
import com.neep.meatweapons.component.MeatgunComponent;
import com.neep.meatweapons.init.MWComponents;
import com.neep.meatweapons.item.meatgun.MeatgunAnimationManager;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.ModuleSlot;
import com.neep.meatweapons.mixin.client.HeldItemRendererAccessor;
import com.neep.meatweapons.network.MeatgunNetwork;
import com.neep.neepmeat.NeepMeat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_1007;
import net.minecraft.class_1059;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_804;
import net.minecraft.class_809;

@Environment(value=EnvType.CLIENT)
public class MeatgunPistolRenderer
implements BuiltinItemRendererRegistry.DynamicItemRenderer {
    private final class_310 client = class_310.method_1551();

    public void render(class_1799 stack, class_809.class_811 mode, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        matrices.method_22909();
        matrices.method_22903();
        class_746 player = this.client.field_1724;
        class_1007 playerEntityRenderer = (class_1007)class_310.method_1551().method_1561().method_3953((class_1297)player);
        boolean mainHand = ((HeldItemRendererAccessor)this.client.field_1773.field_4012).getMainHand().equals(stack);
        boolean leftHanded = mode.method_29998() && (player.method_6068() == class_1306.field_6182 && mainHand || player.method_6068() == class_1306.field_6183 && !mainHand);
        class_804 transformation = class_310.method_1551().method_1480().method_4012().method_3308(stack).method_4709().method_3503(mode);
        transformation.method_23075(leftHanded, matrices);
        matrices.method_22904(-0.5, -0.5, -0.5);
        this.renderInner(stack, (class_742)player, playerEntityRenderer, mode, matrices, vcp, true, mainHand, leftHanded, AnimationTickHolder.getPartialTicks(), light, overlay);
    }

    protected void renderInner(class_1799 stack, class_742 player, class_1007 playerEntityRenderer, class_809.class_811 mode, class_4587 matrices, class_4597 vcp, boolean showArm, boolean mainHand, boolean leftHanded, float tickDelta, int light, int overlay) {
        MeatgunComponent component = (MeatgunComponent)MWComponents.MEATGUN.get((Object)stack);
        showArm = this.applyAnimations(matrices, mode, component, tickDelta, leftHanded);
        RecoilManager recoil = component.getRecoil();
        if (mode.method_29998()) {
            float lastFrame = !this.client.method_1493() ? this.client.method_1534() : 0.0f;
            float prevHorAmount = recoil.horAmount;
            recoil.horAmount -= Math.signum(recoil.horAmount) * recoil.horReturnSpeed * lastFrame;
            if (Math.signum(prevHorAmount) != Math.signum(recoil.horAmount)) {
                recoil.horReturnSpeed = 0.0f;
            }
            float prevAmount = recoil.amount;
            recoil.amount -= Math.signum(recoil.amount) * recoil.returnSpeed * lastFrame;
            if (Math.signum(prevAmount) != Math.signum(recoil.amount)) {
                recoil.direction = MeatgunNetwork.RecoilDirection.UP;
                recoil.returnSpeed = 0.0f;
            }
            this.transformRecoil(matrices, recoil, leftHanded);
        }
        Matrix4f firstPersonModelTransform = this.getFirstPersonModelTransform();
        matrices.method_22903();
        if (mode.method_29998()) {
            matrices.method_34425(firstPersonModelTransform.as());
        }
        MeatgunModule root = component.getRootHolder().root;
        this.renderRecursive(matrices, root, stack, component, mode, vcp, class_310.method_1551().field_1687.method_8510(), class_310.method_1551().method_1488(), light, overlay);
        this.renderScreen(matrices, mode, vcp, component.getRootHolder(), tickDelta, leftHanded);
        matrices.method_22909();
        this.renderParticles(matrices, mode, firstPersonModelTransform, vcp, light, overlay);
        if (showArm) {
            this.renderArms(matrices, mode, player, playerEntityRenderer, vcp, light, mainHand, leftHanded);
        }
    }

    protected boolean applyAnimations(class_4587 matrices, class_809.class_811 mode, MeatgunComponent component, float tickDelta, boolean leftHanded) {
        MeatgunAnimationManager animationManager;
        if (mode.method_29998() && (animationManager = component.getAnimationManager()) != null) {
            MeatgunAnimation animation = animationManager.getActive();
            return animation.applyRender(matrices, tickDelta, leftHanded);
        }
        return true;
    }

    protected void transformRecoil(class_4587 matrices, RecoilManager recoil, boolean leftHand) {
        matrices.method_22904(0.0, 0.0, (double)recoil.horAmount);
        matrices.method_22904(0.0, 0.0, 1.4);
        matrices.method_22907(RotationAxis.POSITIVE_X.rotationDegrees(recoil.direction == MeatgunNetwork.RecoilDirection.DOWN ? -recoil.amount : recoil.amount));
        matrices.method_22904(0.0, 0.0, -1.4);
    }

    protected Matrix4f getFirstPersonModelTransform() {
        float modelScale = 1.2f;
        return new Matrix4f().scaleAround(modelScale, modelScale, modelScale, 0.5f, 0.0f, 0.0f).translate(0.0f, 0.21875f, -0.5625f);
    }

    protected void renderParticles(class_4587 matrices, class_809.class_811 mode, Matrix4f modelTransform, class_4597 vcp, int light, int overlay) {
        if (mode.method_29998()) {
            matrices.method_22903();
            matrices.method_34425(modelTransform.as());
            class_4184 camera = this.client.field_1773.method_19418();
            matrices.method_22904(0.5, 0.0, 1.0);
            class_4588 consumer = vcp.getBuffer(class_1921.method_23580((class_2960)class_1059.field_17898));
            for (MeatgunParticle particle : MeatgunParticleManager.getParticles()) {
                particle.render(matrices, camera, consumer, overlay, this.client.method_1488());
            }
            matrices.method_22909();
        }
    }

    protected void renderArms(class_4587 matrices, class_809.class_811 mode, class_742 player, class_1007 playerEntityRenderer, class_4597 vcp, int light, boolean mainHand, boolean leftHanded) {
        matrices.method_22903();
        class_1268 hand = mainHand ? class_1268.field_5808 : class_1268.field_5810;
        class_1268 otherHand = mainHand ? class_1268.field_5810 : class_1268.field_5808;
        float armScale = 1.4f;
        float cx = -0.25f;
        float cy = 0.25f;
        float cz = -0.5f;
        Matrix4f t = new Matrix4f().translate(cx, cy, cz).scale(armScale, armScale, armScale).translate(-cx, -cy, -cz).translate((float)(leftHanded ? 0 : 12) / 16.0f / armScale, -0.25f / armScale, 1.25f / armScale);
        matrices.method_34425(t.as());
        if (mode.method_29998()) {
            if (leftHanded) {
                this.renderArm(((class_591)playerEntityRenderer.method_4038()).field_27433, true, matrices, player, vcp, light);
                this.renderArm(((class_591)playerEntityRenderer.method_4038()).field_3484, true, matrices, player, vcp, light);
            } else {
                this.renderArm(((class_591)playerEntityRenderer.method_4038()).field_3401, false, matrices, player, vcp, light);
                this.renderArm(((class_591)playerEntityRenderer.method_4038()).field_3486, false, matrices, player, vcp, light);
            }
        }
        matrices.method_22909();
    }

    private void renderArm(class_630 armPart, boolean leftHanded, class_4587 matrices, class_742 player, class_4597 vcp, int light) {
        armPart.field_3654 = (float)Math.toRadians(-90.0);
        armPart.field_3675 = 0.0f;
        armPart.field_3674 = (float)Math.PI;
        armPart.method_22698(matrices, vcp.getBuffer(class_1921.method_23576((class_2960)player.method_3117())), light, class_4608.field_21444);
    }

    protected void renderScreen(class_4587 matrices, class_809.class_811 mode, class_4597 vcp, RootModuleHolder holder, float tickDelta, boolean leftHanded) {
        if (mode == class_809.class_811.field_4318 || mode == class_809.class_811.field_4317 || mode == class_809.class_811.field_4319 || mode == class_809.class_811.field_4316 || mode == class_809.class_811.field_4315) {
            return;
        }
        if (!((Boolean)NeepMeat.CONFIG.meatgunAmmoOnModel.getRealValue()).booleanValue()) {
            return;
        }
        matrices.method_22903();
        float sf1 = 0.004f;
        matrices.method_22904((double)((float)(leftHanded ? 10 : 2) / 16.0f), 0.125, 1.125);
        matrices.method_22905(sf1, -sf1, 1.0f);
        class_4597.class_4598 vcp2 = this.client.method_22940().method_23000();
        MeatgunClient.renderHud(matrices, (class_4597)vcp2, tickDelta, holder, false);
        vcp2.method_22993();
        matrices.method_22909();
    }

    private <T extends MeatgunModule> void renderRecursive(class_4587 matrices, T module, class_1799 stack, MeatgunComponent component, class_809.class_811 mode, class_4597 vcp, long time, float tickDelta, int light, int overlay) {
        if (module == MeatgunModule.DEFAULT) {
            return;
        }
        MeatgunModuleRenderer<T> renderer = MeatgunModuleRenderers.get(module);
        renderer.render(stack, component, module, mode, matrices, vcp, time, tickDelta, light, overlay);
        for (ModuleSlot child : module.getChildren()) {
            matrices.method_22903();
            matrices.method_22904(0.5, 0.0, 1.0);
            Matrix4f matrix4f = child.transform(tickDelta);
            matrices.method_34425(matrix4f.as());
            matrices.method_22904(-0.5, 0.0, -1.0);
            this.renderRecursive(matrices, child.get(), stack, component, mode, vcp, time, tickDelta, light, overlay);
            matrices.method_22909();
        }
    }
}

