/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.entity;

import com.neep.neepmeat.init.NMSounds;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class MeatgunProjectileEntity
extends class_1665 {
    protected float homingRadius;
    protected float homingSpeed;
    @Nullable
    protected class_1297 homingTarget;
    protected boolean prioritiseHoming;
    protected int collisions = 0;
    protected int collidedTicks = 0;
    protected float distanceMoved = 0.0f;

    public MeatgunProjectileEntity(class_1299<? extends MeatgunProjectileEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void method_5773() {
        double prevX = this.method_23317();
        double prevY = this.method_23318();
        double prevZ = this.method_23321();
        super.method_5773();
        double dx = this.method_23317() - prevX;
        double dy = this.method_23318() - prevY;
        double dz = this.method_23321() - prevZ;
        this.distanceMoved = (float)((double)this.distanceMoved + Math.sqrt(dx * dx + dy * dy + dz * dz));
        this.tickHoming();
        if (this.collisions > 0) {
            ++this.collidedTicks;
        }
    }

    protected void tickHoming() {
        if (this.method_37908().method_8608()) {
            return;
        }
        if (this.homingRadius > 0.0f && this.homingTarget == null && this.field_6012 % 2 == 0) {
            class_238 box = class_238.method_30048((class_243)this.method_19538(), (double)(this.homingRadius * 2.0f), (double)(this.homingRadius * 2.0f), (double)(this.homingRadius * 2.0f));
            List entityList = this.method_37908().method_18023(class_5575.method_31795(class_1309.class), box, this::method_26958);
            double leastDistance = Double.MAX_VALUE;
            class_1309 target = null;
            for (class_1309 entity : entityList) {
                double distance = entity.method_5858((class_1297)this);
                if (!(distance < leastDistance)) continue;
                leastDistance = distance;
                target = entity;
            }
            if (target != null) {
                this.homingTarget = target;
            }
        }
        if (this.homingTarget != null) {
            class_243 vel = this.method_18798();
            if (this.prioritiseHoming) {
                vel = vel.method_1021((double)0.8f);
            }
            class_243 toTarget = new class_243(this.homingTarget.method_23317() - this.method_23317(), this.homingTarget.method_23320() - this.method_23318(), this.homingTarget.method_23321() - this.method_23321()).method_1029().method_1021(this.homingSpeed >= 0.0f ? (double)this.homingSpeed : (double)this.field_28627);
            this.method_18799(vel.method_1019(toTarget));
        }
    }

    protected boolean method_34713(class_1657 player) {
        return false;
    }

    protected boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && !this.method_34714(entity);
    }

    public void method_24919(class_1297 shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        super.method_24919(shooter, pitch, yaw, roll, speed, divergence);
        if (this.homingSpeed <= 0.0f) {
            this.setHomingSpeed(speed / 2.0f, this.prioritiseHoming);
        }
    }

    protected class_1799 method_7445() {
        return class_1799.field_8037;
    }

    protected void method_7488(class_239 hitResult) {
        class_239.class_240 type = hitResult.method_17783();
        if (type == class_239.class_240.field_1331) {
            this.method_7454((class_3966)hitResult);
            this.method_37908().method_32888(class_5712.field_28162, hitResult.method_17784(), class_5712.class_7397.method_43286((class_1297)this, null));
        } else if (type == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)hitResult;
            this.method_24920(blockHitResult);
            class_2338 blockPos = blockHitResult.method_17777();
            this.method_37908().method_43276(class_5712.field_28162, blockPos, class_5712.class_7397.method_43286((class_1297)this, (class_2680)this.method_37908().method_8320(blockPos)));
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        ++this.collisions;
    }

    protected void method_24920(class_3965 blockHitResult) {
        ++this.collisions;
    }

    public void method_5783(@Nullable class_3414 sound, float volume, float pitch) {
        if (sound == null) {
            return;
        }
        super.method_5783(sound, volume, pitch);
    }

    protected class_3414 method_7440() {
        return NMSounds.SHOCK_STAFF_HIT;
    }

    public void setHomingRadius(float homingRadius) {
        this.homingRadius = homingRadius;
    }

    public void setHomingTarget(class_1297 target) {
        this.homingTarget = target;
    }

    public void setHomingSpeed(float homingSpeed, boolean prioritiseHoming) {
        this.homingSpeed = homingSpeed;
        this.prioritiseHoming = prioritiseHoming;
    }

    public class_2487 method_5647(class_2487 nbt) {
        super.method_5647(nbt);
        nbt.method_10548("homing_range", this.homingRadius);
        nbt.method_10556("prioritise_homing", this.prioritiseHoming);
        nbt.method_10548("homing_speed", this.homingSpeed);
        return nbt;
    }

    public void method_5651(class_2487 nbt) {
        super.method_5651(nbt);
        this.homingRadius = nbt.method_10583("homing_range");
        this.prioritiseHoming = nbt.method_10577("prioritise_homing");
        this.homingSpeed = nbt.method_10583("homing_speed");
    }
}

