/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.item;

import com.neep.meatlib.item.ClientBlockAttackListener;
import com.neep.meatlib.item.CustomEnchantable;
import com.neep.meatlib.item.MeatlibItem;
import com.neep.meatlib.item.PoweredItem;
import com.neep.meatlib.item.TooltipSupplier;
import com.neep.meatweapons.MWItems;
import com.neep.meatweapons.client.sound.DrillSoundInstance;
import com.neep.meatweapons.component.AssaultDrillComponent;
import com.neep.meatweapons.entity.BulletDamageSource;
import com.neep.meatweapons.init.MWComponents;
import com.neep.neepmeat.api.item.OverrideSwingItem;
import com.neep.neepmeat.item.util.LivingItemStorage;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5632;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AssaultDrillItem
extends class_1792
implements MeatlibItem,
PoweredItem,
CustomEnchantable,
OverrideSwingItem,
ClientBlockAttackListener {
    public static final class_2960 CHANNEL_ID = new class_2960("assault_drill");
    private final class_6862<class_2248> effectiveBlocks;
    private final float miningSpeed;
    private final class_1322 eam = new class_1322("aa", 8.0, class_1322.class_1323.field_6328);
    protected float attackDamage = 1.5f;
    public static final int BAR_COL = class_3532.method_15369((float)0.5f, (float)0.75f, (float)0.75f);

    public AssaultDrillItem(int maxDamage, FabricItemSettings settings) {
        super((class_1792.class_1793)settings.maxCount(1).maxDamage(maxDamage));
        this.effectiveBlocks = class_3481.field_33715;
        this.miningSpeed = class_1834.field_8930.method_8027();
    }

    public static boolean using(class_1799 stack) {
        AssaultDrillComponent component = (AssaultDrillComponent)MWComponents.ASSAULT_DRILL.getNullable((Object)stack);
        if (component != null) {
            return component.using() || component.attacking();
        }
        return false;
    }

    public static Storage<FluidVariant> getStorage(class_1799 stack, ContainerItemContext containerItemContext) {
        return new LivingItemStorage(stack, containerItemContext);
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        TooltipSupplier.wrapLines(tooltip, (class_2561)class_2561.method_43471((String)"item.meatweapons.assault_drill.lore"));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.meatweapons.assault_drill.damage_per_tick", (Object[])new Object[]{Float.valueOf(this.getDamage(itemStack, null) / 2.0f)}).method_27692(class_124.field_1078));
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        user.method_6019(hand);
        MWComponents.ASSAULT_DRILL.maybeGet((Object)itemStack).ifPresent(c -> c.setUsing(true));
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        boolean canUse = true;
        if (stack.method_7919() >= this.getMaxDamage(stack)) {
            MWComponents.ASSAULT_DRILL.maybeGet((Object)stack).ifPresent(c -> c.setUsing(false));
            canUse = false;
        }
        double radius = 1.3;
        double distance = 1.2;
        class_243 tip = user.method_33571().method_1019(user.method_5828(1.0f).method_1029().method_1021(distance));
        class_238 box = class_238.method_30048((class_243)tip, (double)radius, (double)radius, (double)radius);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (canUse) {
                class_1657 player;
                List entities = world.method_8333((class_1297)user, box, e -> true);
                if (!entities.isEmpty()) {
                    entities.forEach(entity -> {
                        if (entity instanceof class_1309 && entity.method_5805() && user instanceof class_1657) {
                            class_1657 player = (class_1657)user;
                            entity.method_5643((class_1282)BulletDamageSource.create((class_1309)player, 0.04f, 14), this.getDamage(stack, (class_1297)entity));
                            serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10541.method_9564()), tip.field_1352, tip.field_1351, tip.field_1350, 3, 0.05, 0.05, 0.05, 0.2);
                        }
                    });
                }
                if (!(user instanceof class_1657 && (player = (class_1657)user).method_7337() || stack.method_7919() >= this.getMaxDamage(stack))) {
                    stack.method_7974(stack.method_7919() + 1);
                }
            }
        }
        super.method_7852(world, user, stack, remainingUseTicks);
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!world.field_9236 && state.method_26214((class_1922)world, pos) != 0.0f && stack.method_7919() < this.method_7841()) {
            if (stack.method_7919() == this.getMaxDamage(stack) - 1) {
                stack.method_7974(this.getMaxDamage(stack));
            } else {
                stack.method_7956(1, miner, e -> {});
            }
        }
        return true;
    }

    public int getMaxDamage(class_1799 stack) {
        return stack.method_7936();
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return super.method_32346(stack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        MWComponents.ASSAULT_DRILL.maybeGet((Object)stack).ifPresent(c -> c.setUsing(false));
    }

    protected float getDamage(class_1799 stack, @Nullable class_1297 target) {
        float f;
        if (target instanceof class_1309) {
            class_1309 livingTarget = (class_1309)target;
            f = class_1890.method_8218((class_1799)stack, (class_1310)livingTarget.method_6046());
        } else {
            f = class_1890.method_8218((class_1799)stack, (class_1310)class_1310.field_6290);
        }
        float damage = f;
        return this.attackDamage + damage;
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        if (stack.method_7919() >= this.method_7841()) {
            return 1.0f;
        }
        return state.method_26164(this.effectiveBlocks) ? this.miningSpeed * 4.0f : 1.0f;
    }

    public boolean method_7856(class_2680 state) {
        return state.method_26164(this.effectiveBlocks);
    }

    public int method_31569(class_1799 stack) {
        return super.method_31569(stack);
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public boolean method_7846() {
        return false;
    }

    public int method_31571(class_1799 stack) {
        return BAR_COL;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public int method_7837() {
        return 1;
    }

    @Override
    public void onAttackBlock(class_1799 stack, class_1657 player) {
        if (stack.method_7919() < this.method_7841()) {
            this.sendAttack(true);
        }
    }

    @Override
    public void onFinishAttackBlock(class_1799 stack, class_1657 player) {
        this.sendAttack(false);
    }

    @Override
    public boolean onSwing(class_1799 stack, class_1657 player) {
        player.field_6251 = 0.0f;
        return false;
    }

    private void sendAttack(boolean attacking) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(attacking);
        ClientPlayNetworking.send((class_2960)CHANNEL_ID, (class_2540)buf);
    }

    private static void onAttackPacket(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        boolean attacking = buf.readBoolean();
        server.execute(() -> {
            class_1799 mainStack = player.method_6047();
            if (mainStack.method_7909() instanceof AssaultDrillItem) {
                MWComponents.ASSAULT_DRILL.maybeGet((Object)mainStack).ifPresent(c -> c.setAttacking(attacking));
            }
        });
    }

    static {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL_ID, AssaultDrillItem::onAttackPacket);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        private static final DrillSoundInstance soundInstance = new DrillSoundInstance();

        public static void init() {
            ClientTickEvents.START_CLIENT_TICK.register(Client::tick);
        }

        public static void tick(class_310 client) {
            class_1144 manager = client.method_1483();
            class_746 player = client.field_1724;
            if (player != null) {
                if (player.method_5998(class_1268.field_5808).method_31574(MWItems.ASSAULT_DRILL)) {
                    if (!manager.method_4877((class_1113)soundInstance)) {
                        soundInstance.setPlayer((class_1657)player);
                        manager.method_4873((class_1113)soundInstance);
                    }
                } else if (manager.method_4877((class_1113)soundInstance)) {
                    manager.method_4870((class_1113)soundInstance);
                }
            }
        }
    }
}

