/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.meatgun;

import com.neep.meatweapons.component.MeatgunComponent;
import com.neep.meatweapons.implant.BloodBulletProviderImplant;
import com.neep.meatweapons.implant.MagazineOrganImplant;
import com.neep.meatweapons.item.meatgun.Meatgun;
import com.neep.meatweapons.meatgun.AmmunitionProvider;
import com.neep.meatweapons.meatgun.AmmunitionTransaction;
import com.neep.meatweapons.meatgun.AmmunitionType;
import com.neep.meatweapons.meatgun.ModuleCache;
import com.neep.meatweapons.meatgun.module.AmmunitionRequiringModule;
import com.neep.meatweapons.meatgun.module.AmmunitionStoringModule;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.network.MeatgunNetwork;
import com.neep.neepmeat.implant.entity.PlayerImplantManager;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.init.NMSounds;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class RootModuleHolder {
    public static final UUID NULL_UUID = new UUID(0L, 0L);
    public final MeatgunModule root;
    private final Meatgun meatgun;
    @Nullable
    private MeatgunComponent component;
    private int remainingCapacity = -1;
    private final Listener listener = new ListenerImpl();
    private final ModuleCache cache;

    public RootModuleHolder(Meatgun meatgun) {
        this.root = meatgun.createBase(this.listener);
        this.meatgun = meatgun;
        this.cache = new ModuleCache(this.root);
    }

    public void setComponent(@Nullable MeatgunComponent component) {
        this.component = component;
    }

    public void markDirty(Reason reason) {
        if (this.component != null) {
            this.component.markDirty();
        }
        if (reason == Reason.MODULE_SWAPPED) {
            if (this.cache != null) {
                this.cache.invalidate();
            }
            this.remainingCapacity = -1;
        }
    }

    public UUID getUuid() {
        return this.component != null ? this.component.getUuid() : NULL_UUID;
    }

    public boolean containsType(MeatgunModule.Type<?> type) {
        return this.cache.moduleTypes().contains(type);
    }

    private void cacheModules() {
        if (this.remainingCapacity == -1 && this.component != null) {
            this.remainingCapacity = this.meatgun.getMaxComplexity(this.component.getStack());
            for (MeatgunModule module : this.cache.getModules()) {
                this.remainingCapacity -= module.getType().complexity();
            }
        }
    }

    public void readNbt(class_2487 rootTag) {
        this.root.readNbt(rootTag);
    }

    public Listener getListener() {
        return this.listener;
    }

    public int getRemainingComplexity() {
        this.cacheModules();
        return this.remainingCapacity;
    }

    public int getMaxComplexity(class_1799 stack) {
        return this.meatgun.getMaxComplexity(stack);
    }

    public boolean canSupport(MeatgunModule.Type<?> type) {
        this.cacheModules();
        return this.remainingCapacity >= type.complexity();
    }

    public AmmunitionTransaction getAmmoOrReload(AmmunitionRequiringModule module, int amount, class_1263 inventory, class_1657 player) {
        boolean satisfied;
        PlayerImplantManager manager = (PlayerImplantManager)NMComponents.IMPLANT_MANAGER.get((Object)player);
        boolean hasBloodBullets = manager.isInstalled(BloodBulletProviderImplant.ID);
        this.cacheModules();
        int available = this.cache.getAmmo(module.ammoType());
        boolean bl = satisfied = available >= amount;
        if (!satisfied) {
            AmmunitionProvider provider;
            boolean reloaded = false;
            @Nullable MagazineOrganImplant implant = (MagazineOrganImplant)manager.getImplant(MagazineOrganImplant.ID);
            if (implant != null && (provider = implant.provide(module.ammoType(), amount)) != null && (reloaded = this.reload(provider, player, false))) {
                return AmmunitionTransaction.EMPTY;
            }
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                @Nullable AmmunitionProvider provider2 = (AmmunitionProvider)AmmunitionProvider.LOOKUP.find(stack, (Object)new AmmunitionProvider.InventoryContext(inventory, i));
                if (provider2 == null || provider2.ammoType() != module.ammoType() || !(reloaded = this.reload(provider2, player, true))) continue;
                return AmmunitionTransaction.EMPTY;
            }
        }
        AmmunitionTransaction transaction = () -> {};
        int required = amount;
        if (satisfied || hasBloodBullets) {
            for (MeatgunModule otherModule : this.cache.getModules()) {
                AmmunitionStoringModule storage;
                if (!(otherModule instanceof AmmunitionStoringModule) || (storage = (AmmunitionStoringModule)((Object)otherModule)).ammoType() != module.ammoType()) continue;
                if (storage.amount() > 0) {
                    int canExtract = Math.min(storage.amount(), required);
                    transaction = transaction.chain(this.consumeFromModule(storage, canExtract));
                    required -= canExtract;
                }
                if (required != 0) continue;
                return transaction.chain(() -> this.listener.markDirty(Reason.SAVE_DATA));
            }
        }
        if (required > 0 && hasBloodBullets) {
            return transaction.chain(this.consumeBlood(module.ammoType(), required, player)).chain(() -> this.listener.markDirty(Reason.SAVE_DATA));
        }
        return AmmunitionTransaction.EMPTY;
    }

    private AmmunitionTransaction consumeFromModule(AmmunitionStoringModule module, int amount) {
        return () -> module.extract(amount);
    }

    private AmmunitionTransaction consumeBlood(AmmunitionType type, int required, class_1657 player) {
        return () -> {
            float healthPerUnit = type.healthPerUnit;
            float fractionalHearts = healthPerUnit * (float)required;
            player.method_5643(class_1282.field_5869, fractionalHearts);
        };
    }

    public boolean reload(AmmunitionProvider provider, class_1657 player, boolean consume) {
        this.cacheModules();
        int current = this.cache.getAmmo(provider.ammoType());
        if (current >= provider.getAmount()) {
            return false;
        }
        int remaining = provider.getAmount() - current;
        for (MeatgunModule otherModule : this.cache.getModules()) {
            AmmunitionStoringModule storage;
            if (otherModule instanceof AmmunitionStoringModule && (storage = (AmmunitionStoringModule)((Object)otherModule)).ammoType() == provider.ammoType() && (remaining -= storage.insert(remaining)) <= 0) break;
        }
        if (remaining < provider.getAmount()) {
            if (consume) {
                provider.consume();
            }
            this.listener.markDirty(Reason.SAVE_DATA);
            player.method_17356(NMSounds.RELOAD_MECHANICAL_HISS, class_3419.field_15248, 1.0f, 1.0f);
            MeatgunNetwork.SEND_ANIMATION.emitter(player).apply("reload", PacketByteBufs.create().method_10804(10));
            return true;
        }
        return false;
    }

    public ModuleCache moduleCache() {
        return this.cache;
    }

    public class_1799 getOwningItemStack() {
        return this.component != null ? this.component.getStack() : class_1799.field_8037;
    }

    private class ListenerImpl
    implements Listener {
        private ListenerImpl() {
        }

        @Override
        public RootModuleHolder getHolder() {
            return RootModuleHolder.this;
        }

        @Override
        public void markDirty(Reason reason) {
            RootModuleHolder.this.markDirty(reason);
        }
    }

    public static interface Listener {
        public RootModuleHolder getHolder();

        public void markDirty(Reason var1);
    }

    public static enum Reason {
        MODULE_SWAPPED,
        SAVE_DATA;

    }
}

